/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.support;

import com.firefly.utils.ConvertUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamMetaInfo {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final Class<?> paramClass;
    private final Map<String, Method> beanSetMethod;
    private final String attribute;

    public ParamMetaInfo(Class<?> paramClass, Map<String, Method> beanSetMethod, String attribute) {
        this.paramClass = paramClass;
        this.beanSetMethod = beanSetMethod;
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setParam(Object o, String key, String value) {
        try {
            Method m = this.beanSetMethod.get(key);
            if (m != null) {
                Class<?> p = m.getParameterTypes()[0];
                m.invoke(o, ConvertUtils.convert((String)value, p));
            }
        }
        catch (Throwable t) {
            log.error("set param error", t);
        }
    }

    public Object newParamInstance() {
        Object o = null;
        try {
            o = this.paramClass.newInstance();
        }
        catch (Throwable t) {
            log.error("new param error", t);
        }
        return o;
    }

    public Class<?> getParamClass() {
        return this.paramClass;
    }
}

