/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.support;

import com.firefly.annotation.HttpParam;
import com.firefly.annotation.JsonBody;
import com.firefly.annotation.PathVariable;
import com.firefly.mvc.web.HandlerChain;
import com.firefly.mvc.web.View;
import com.firefly.mvc.web.support.MethodParam;
import com.firefly.mvc.web.support.ParamMetaInfo;
import com.firefly.mvc.web.support.exception.WebException;
import com.firefly.server.http2.servlet.HttpStringBodyRequest;
import com.firefly.utils.ReflectUtils;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.io.IO;
import com.firefly.utils.json.Json;
import com.firefly.utils.json.JsonArray;
import com.firefly.utils.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HandlerMetaInfo {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private static final Set<Class<?>> ANNOTATION_TYPES = new HashSet<Class>(Arrays.asList(HttpParam.class, PathVariable.class, JsonBody.class));
    protected final Object object;
    protected final ReflectUtils.MethodProxy proxy;
    protected final MethodParam[] methodParam;
    protected final ParamMetaInfo[] paramMetaInfos;

    public HandlerMetaInfo(Object object, Method method) {
        this.object = object;
        try {
            this.proxy = ReflectUtils.getMethodProxy((Method)method);
        }
        catch (Throwable e) {
            log.error("handler init error", e);
            throw new WebException("handler invoke error");
        }
        Class<?>[] paraTypes = method.getParameterTypes();
        this.methodParam = new MethodParam[paraTypes.length];
        this.paramMetaInfos = new ParamMetaInfo[paraTypes.length];
        for (int i = 0; i < paraTypes.length; ++i) {
            ParamMetaInfo paramMetaInfo;
            if (paraTypes[i].equals(HttpServletRequest.class)) {
                this.methodParam[i] = MethodParam.REQUEST;
                continue;
            }
            if (paraTypes[i].equals(HttpServletResponse.class)) {
                this.methodParam[i] = MethodParam.RESPONSE;
                continue;
            }
            if (paraTypes[i].equals(HandlerChain.class)) {
                this.methodParam[i] = MethodParam.HANDLER_CHAIN;
                continue;
            }
            Annotation[][] annotations = method.getParameterAnnotations();
            Annotation anno = this.getAnnotation(annotations[i]);
            if (anno != null) {
                if (anno.annotationType().equals(HttpParam.class)) {
                    ParamMetaInfo paramMetaInfo2;
                    HttpParam httpParam = (HttpParam)anno;
                    this.paramMetaInfos[i] = paramMetaInfo2 = new ParamMetaInfo(paraTypes[i], ReflectUtils.getSetterMethods(paraTypes[i]), httpParam.value());
                    this.methodParam[i] = MethodParam.HTTP_PARAM;
                    continue;
                }
                if (anno.annotationType().equals(PathVariable.class)) {
                    if (!paraTypes[i].equals(String[].class)) continue;
                    this.methodParam[i] = MethodParam.PATH_VARIBLE;
                    continue;
                }
                if (!anno.annotationType().equals(JsonBody.class)) continue;
                this.paramMetaInfos[i] = paramMetaInfo = new ParamMetaInfo(paraTypes[i], ReflectUtils.getSetterMethods(paraTypes[i]), "");
                this.methodParam[i] = MethodParam.JSON_BODY;
                continue;
            }
            this.paramMetaInfos[i] = paramMetaInfo = new ParamMetaInfo(paraTypes[i], ReflectUtils.getSetterMethods(paraTypes[i]), "");
            this.methodParam[i] = MethodParam.HTTP_PARAM;
        }
    }

    private Annotation getAnnotation(Annotation[] annotations) {
        for (Annotation a : annotations) {
            if (!ANNOTATION_TYPES.contains(a.annotationType())) continue;
            return a;
        }
        return null;
    }

    public MethodParam[] getMethodParam() {
        return this.methodParam;
    }

    public final View invoke(Object[] args) {
        return (View)this.proxy.invoke(this.object, args);
    }

    public ParamMetaInfo[] getParamMetaInfos() {
        return this.paramMetaInfos;
    }

    /*
     * Unable to fully structure code
     */
    public Object[] getParameters(HttpServletRequest request, HttpServletResponse response, HandlerChain chain, String[] pathParameters) {
        p = new Object[this.methodParam.length];
        block18: for (i = 0; i < p.length; ++i) {
            switch (1.$SwitchMap$com$firefly$mvc$web$support$MethodParam[this.methodParam[i].ordinal()]) {
                case 1: {
                    p[i] = request;
                    continue block18;
                }
                case 2: {
                    p[i] = response;
                    continue block18;
                }
                case 3: {
                    p[i] = chain;
                    continue block18;
                }
                case 4: {
                    enumeration = request.getParameterNames();
                    paramMetaInfo = this.paramMetaInfos[i];
                    p[i] = paramMetaInfo.newParamInstance();
                    while (enumeration.hasMoreElements()) {
                        httpParamName = (String)enumeration.nextElement();
                        paramValue = request.getParameter(httpParamName);
                        paramMetaInfo.setParam(p[i], httpParamName, paramValue);
                    }
                    if (!VerifyUtils.isNotEmpty((String)paramMetaInfo.getAttribute())) continue block18;
                    request.setAttribute(paramMetaInfo.getAttribute(), p[i]);
                    continue block18;
                }
                case 5: {
                    p[i] = pathParameters;
                    continue block18;
                }
                case 6: {
                    if (request instanceof HttpStringBodyRequest) {
                        r = (HttpStringBodyRequest)request;
                        paramMetaInfo = this.paramMetaInfos[i];
                        if (paramMetaInfo.getParamClass().equals(JsonObject.class)) {
                            p[i] = r.getJsonObjectBody();
                            continue block18;
                        }
                        if (paramMetaInfo.getParamClass().equals(JsonArray.class)) {
                            p[i] = r.getJsonArrayBody();
                            continue block18;
                        }
                        p[i] = r.getJsonBody(paramMetaInfo.getParamClass());
                        continue block18;
                    }
                    paramMetaInfo = this.paramMetaInfos[i];
                    try {
                        in = request.getInputStream();
                        var9_10 = null;
                        stringBody = IO.toString((InputStream)in, (String)request.getCharacterEncoding());
                        p[i] = paramMetaInfo.getParamClass().equals(JsonObject.class) != false ? Json.toJsonObject((String)stringBody) : (paramMetaInfo.getParamClass().equals(JsonArray.class) != false ? Json.toJsonArray((String)stringBody) : Json.toObject((String)stringBody, paramMetaInfo.getParamClass()));
                        if (in == null) continue block18;
                        if (var9_10 == null) ** GOTO lbl55
                        try {
                            in.close();
                        }
                        catch (Throwable var10_12) {
                            var9_10.addSuppressed(var10_12);
                        }
                        continue block18;
lbl55:
                        // 1 sources

                        in.close();
                        ** break;
                        catch (Throwable var10_13) {
                            try {
                                var9_10 = var10_13;
                                throw var10_13;
                            }
                            catch (Throwable var11_14) {
                                if (in != null) {
                                    if (var9_10 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var12_15) {
                                            var9_10.addSuppressed(var12_15);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                throw var11_14;
lbl72:
                                // 1 sources

                            }
                        }
                    }
                    catch (IOException e) {
                        HandlerMetaInfo.log.error("get http request string body exception", (Throwable)e);
                    }
                    continue block18;
                }
            }
        }
        return p;
    }

    public String toString() {
        return "HandlerMetaInfo [method=" + this.proxy.method() + ", methodParam=" + Arrays.toString((Object[])this.methodParam) + "]";
    }
}

