/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.support;

import com.firefly.annotation.MultipartSettings;
import com.firefly.annotation.RequestMapping;
import com.firefly.mvc.web.support.HandlerMetaInfo;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.MultipartConfigElement;

public class ControllerMetaInfo
extends HandlerMetaInfo {
    private final Set<String> allowHttpMethod;
    private final MultipartConfigElement multipartConfigElement;

    public ControllerMetaInfo(Object object, Method method) {
        super(object, method);
        this.allowHttpMethod = new HashSet<String>(Arrays.asList(method.getAnnotation(RequestMapping.class).method()));
        MultipartSettings s = method.getAnnotation(MultipartSettings.class);
        this.multipartConfigElement = s != null ? new MultipartConfigElement(s.location(), s.maxFileSize(), s.maxRequestSize(), s.fileSizeThreshold()) : null;
    }

    public MultipartConfigElement getMultipartConfigElement() {
        return this.multipartConfigElement;
    }

    public boolean allowMethod(String method) {
        return this.allowHttpMethod.contains(method);
    }

    public String getAllowMethod() {
        StringBuilder s = new StringBuilder();
        for (String m : this.allowHttpMethod) {
            s.append(m).append(',');
        }
        s.deleteCharAt(s.length() - 1);
        return s.toString();
    }

    @Override
    public String toString() {
        return "ControllerMetaInfo [allowHttpMethod=" + this.allowHttpMethod + "]";
    }
}

