/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.servlet;

import com.firefly.mvc.web.view.TemplateView;
import com.firefly.template.Model;
import com.firefly.template.TemplateFactory;
import com.firefly.template.View;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemHtmlPage {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private static Map<Integer, String> errorPage = new HashMap<Integer, String>();

    public static void addErrorPage(Integer errorCode, String page) {
        errorPage.put(errorCode, page);
    }

    public static void addErrorPageMap(Map<Integer, String> map) {
        errorPage = map;
    }

    public static void responseSystemPage(HttpServletRequest request, HttpServletResponse response, String charset, int status, String content) {
        response.setStatus(status);
        response.setCharacterEncoding(charset);
        response.setHeader("Content-Type", "text/html; charset=" + charset);
        try (PrintWriter writer = response.getWriter();){
            writer.print(SystemHtmlPage.systemPageTemplate(status, content));
        }
        catch (IOException e) {
            log.error("response system page exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String systemPageTemplate(int status, String content) {
        if (errorPage == null) {
            return SystemHtmlPage.getDefaultErrorPage(status, content);
        }
        String page = errorPage.get(status);
        if (VerifyUtils.isEmpty((String)page)) {
            return SystemHtmlPage.getDefaultErrorPage(status, content);
        }
        TemplateFactory templateFactory = TemplateView.getTemplateFactory();
        if (templateFactory == null) {
            return SystemHtmlPage.getDefaultErrorPage(status, content);
        }
        View v = templateFactory.getView(page);
        if (v == null) {
            return SystemHtmlPage.getDefaultErrorPage(status, content);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        Model model = new Model(){
            private Map<String, Object> map = new HashMap<String, Object>();

            public void put(String key, Object object) {
                this.map.put(key, object);
            }

            public Object get(String key) {
                return this.map.get(key);
            }

            public void remove(String key) {
                this.map.remove(key);
            }

            public void clear() {
                this.map.clear();
            }
        };
        try {
            model.put("#systemErrorMessage", (Object)URLDecoder.decode(content, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("url decode error", (Throwable)e);
        }
        try {
            v.render(model, (OutputStream)out);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                return SystemHtmlPage.getDefaultErrorPage(status, content);
            }
        }
        try {
            return new String(out.toByteArray(), TemplateView.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            return SystemHtmlPage.getDefaultErrorPage(status, content);
        }
    }

    private static String getDefaultErrorPage(int status, String content) {
        StringBuilder ret = new StringBuilder();
        try {
            ret.append("<!DOCTYPE html><html><head><title>firefly</title></head><body><h2>HTTP ERROR ").append(status).append("</h2><div>").append(StringUtils.escapeXML((String)URLDecoder.decode(content, "UTF-8"))).append("</div><hr/><i><small>firefly framework</small></i></body></html>");
        }
        catch (UnsupportedEncodingException e) {
            log.error("url decode error", (Throwable)e);
        }
        return ret.toString();
    }
}

