/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web.servlet;

import com.firefly.mvc.web.DispatcherController;
import com.firefly.mvc.web.HandlerChain;
import com.firefly.mvc.web.View;
import com.firefly.mvc.web.WebContext;
import com.firefly.mvc.web.servlet.SystemHtmlPage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletDispatcherController
implements DispatcherController {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected WebContext webContext;

    public HttpServletDispatcherController(WebContext webContext) {
        this.webContext = webContext;
    }

    @Override
    public void dispatch(HttpServletRequest request, HttpServletResponse response) {
        block10: {
            String encoding = this.webContext.getEncoding();
            try {
                request.setCharacterEncoding(encoding);
            }
            catch (Throwable t) {
                log.error("dispatcher error", t);
            }
            response.setCharacterEncoding(encoding);
            StringBuilder uriBuilder = new StringBuilder(request.getRequestURI());
            uriBuilder.delete(0, request.getContextPath().length() + request.getServletPath().length());
            String servletURI = uriBuilder.length() <= 0 ? null : uriBuilder.toString();
            HandlerChain chain = this.webContext.match(request.getRequestURI(), servletURI);
            View v = null;
            try {
                v = chain.doNext(request, response, chain);
            }
            catch (Throwable e) {
                log.error("dispatcher error", e);
                if (!response.isCommitted()) {
                    String msg = "Server internal error";
                    SystemHtmlPage.responseSystemPage(request, response, this.webContext.getEncoding(), 500, msg);
                }
                return;
            }
            if (request.isAsyncStarted()) {
                return;
            }
            if (v == null) {
                if (!response.isCommitted()) {
                    String msg = request.getRequestURI() + " not found";
                    SystemHtmlPage.responseSystemPage(request, response, this.webContext.getEncoding(), 404, msg);
                }
                return;
            }
            try {
                v.render(request, response);
            }
            catch (Throwable t) {
                log.error("dispatcher error", t);
                if (response.isCommitted()) break block10;
                String msg = "Server internal error";
                SystemHtmlPage.responseSystemPage(request, response, this.webContext.getEncoding(), 500, msg);
            }
        }
    }
}

