/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web;

import com.firefly.mvc.web.View;
import com.firefly.mvc.web.WebHandler;
import com.firefly.mvc.web.servlet.SystemHtmlPage;
import com.firefly.mvc.web.support.ControllerMetaInfo;
import com.firefly.mvc.web.support.URLParser;
import com.firefly.server.http2.servlet.HTTPServletRequestImpl;
import com.firefly.utils.pattern.Pattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Resource {
    public static final String WILDCARD = "?";
    private static final String[] EMPTY = new String[0];
    private static String ENCODING;
    private final Map<String, Result> CONSTANT_URI;
    private String uri;
    private Pattern pattern;
    private ControllerMetaInfo controller;
    private ResourceSet children = new ResourceSet();

    public Resource(String encoding) {
        this.CONSTANT_URI = new HashMap<String, Result>();
        ENCODING = encoding;
    }

    private Resource(boolean root) {
        this.CONSTANT_URI = root ? new HashMap() : null;
    }

    public ControllerMetaInfo getController() {
        return this.controller;
    }

    public String getEncoding() {
        return ENCODING;
    }

    public void add(String uri, ControllerMetaInfo c) {
        if (uri.contains(WILDCARD)) {
            Resource current = this;
            List<String> list = URLParser.parse(uri);
            int max = list.size() - 1;
            int i = 0;
            while (true) {
                String name = list.get(i);
                if (i == max) {
                    current = current.children.add(name, c);
                    return;
                }
                current = current.children.add(name, null);
                ++i;
            }
        }
        char last = uri.charAt(uri.length() - 1);
        if (last != '/') {
            uri = uri + "/";
        }
        Resource resource = new Resource(false);
        resource.uri = uri;
        resource.controller = c;
        Result result = new Result(resource, null);
        this.CONSTANT_URI.put(uri, result);
    }

    public Result match(String uri) {
        Result ret;
        char last = uri.charAt(uri.length() - 1);
        if (last != '/') {
            uri = uri + "/";
        }
        if ((ret = this.CONSTANT_URI.get(uri)) != null) {
            return ret;
        }
        Resource current = this;
        List<String> list = URLParser.parse(uri);
        ArrayList<String> params = new ArrayList<String>();
        for (String i : list) {
            ret = current.children.match(i);
            if (ret == null) {
                return ret;
            }
            if (ret.params != null) {
                for (String p : ret.params) {
                    params.add(p);
                }
            }
            current = ret.resource;
        }
        if (ret == null || ((Result)ret).resource.controller == null) {
            return null;
        }
        if (params.size() > 0) {
            Result.access$302(ret, params.toArray(EMPTY));
        }
        return ret;
    }

    public String toString() {
        return this.toString(" ", "");
    }

    private String toString(String l, String append) {
        StringBuilder s = new StringBuilder();
        s.append(append + this.uri + "(" + this.children.isVariable() + ")\r\n");
        for (Resource r : this.children) {
            s.append(l + r.toString(l + " ", "\u251c"));
        }
        return s.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }

    private class ResourceSet
    implements Iterable<Resource> {
        private Map<String, Resource> map = new HashMap<String, Resource>();
        private List<Resource> list = new LinkedList<Resource>();

        private ResourceSet() {
        }

        private boolean isVariable() {
            return this.list.size() > 0;
        }

        private Result match(String str) {
            Resource ret = this.map.get(str);
            if (ret != null) {
                return new Result(ret, null);
            }
            for (Resource res : this.list) {
                String[] p = res.pattern.match(str);
                if (p == null) continue;
                return new Result(res, p);
            }
            return null;
        }

        private Resource add(String uri, ControllerMetaInfo c) {
            Resource resource = this.findByURI(uri);
            if (resource == null) {
                resource = new Resource(false);
                resource.uri = uri;
                if (uri.contains(Resource.WILDCARD)) {
                    resource.pattern = Pattern.compile((String)resource.uri, (String)Resource.WILDCARD);
                    this.list.add(resource);
                } else {
                    this.map.put(uri, resource);
                }
            }
            if (c != null) {
                resource.controller = c;
            }
            return resource;
        }

        private Resource findByURI(String uri) {
            Resource r = this.map.get(uri);
            if (r != null) {
                return r;
            }
            for (Resource res : this.list) {
                if (!uri.equals(res.uri)) continue;
                return res;
            }
            return null;
        }

        @Override
        public Iterator<Resource> iterator() {
            return new ResourceSetItr();
        }

        private class ResourceSetItr
        implements Iterator<Resource> {
            private Iterator<Resource> listItr;
            private Iterator<Map.Entry<String, Resource>> mapItr;

            private ResourceSetItr() {
                this.listItr = ResourceSet.this.list.iterator();
                this.mapItr = ResourceSet.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mapItr.hasNext() || this.listItr.hasNext();
            }

            @Override
            public Resource next() {
                if (this.mapItr.hasNext()) {
                    return this.mapItr.next().getValue();
                }
                return this.listItr.next();
            }

            @Override
            public void remove() {
                throw new RuntimeException("not implements this method!");
            }
        }
    }

    public static class Result
    implements WebHandler {
        private final Resource resource;
        private String[] params;

        public Result(Resource resource, String[] params) {
            this.resource = resource;
            this.params = params;
        }

        public ControllerMetaInfo getController() {
            return this.resource.controller;
        }

        public String[] getParams() {
            return this.params;
        }

        @Override
        public View invoke(HttpServletRequest request, HttpServletResponse response) {
            if (!this.resource.controller.allowMethod(request.getMethod())) {
                this.notAllowMethodResponse(request, response);
                return null;
            }
            if (this.getController().getMultipartConfigElement() != null && request instanceof HTTPServletRequestImpl) {
                HTTPServletRequestImpl r = (HTTPServletRequestImpl)request;
                r.setMultipartConfigElement(this.getController().getMultipartConfigElement());
            }
            Object[] p = this.getController().getParameters(request, response, null, this.getParams());
            return this.getController().invoke(p);
        }

        private void notAllowMethodResponse(HttpServletRequest request, HttpServletResponse response) {
            response.setHeader("Allow", this.resource.controller.getAllowMethod());
            SystemHtmlPage.responseSystemPage(request, response, ENCODING, 405, "Only support " + this.resource.controller.getAllowMethod() + " method");
        }

        public String toString() {
            return "Result [resource=" + this.resource + ", params=" + Arrays.toString(this.params) + "]";
        }

        static /* synthetic */ String[] access$302(Result x0, String[] x1) {
            x0.params = x1;
            return x1;
        }
    }
}

