/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.mvc.web;

import com.firefly.annotation.RequestMapping;
import com.firefly.core.XmlApplicationContext;
import com.firefly.core.support.BeanDefinition;
import com.firefly.core.support.annotation.AnnotationBeanDefinition;
import com.firefly.core.support.annotation.ConfigReader;
import com.firefly.core.support.xml.XmlBeanReader;
import com.firefly.mvc.web.HandlerChain;
import com.firefly.mvc.web.Resource;
import com.firefly.mvc.web.View;
import com.firefly.mvc.web.WebContext;
import com.firefly.mvc.web.WebHandler;
import com.firefly.mvc.web.servlet.SystemHtmlPage;
import com.firefly.mvc.web.support.ControllerBeanDefinition;
import com.firefly.mvc.web.support.ControllerMetaInfo;
import com.firefly.mvc.web.support.InterceptorBeanDefinition;
import com.firefly.mvc.web.support.InterceptorMetaInfo;
import com.firefly.mvc.web.support.WebBeanReader;
import com.firefly.mvc.web.view.JsonView;
import com.firefly.mvc.web.view.JspView;
import com.firefly.mvc.web.view.TemplateView;
import com.firefly.mvc.web.view.TextView;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AnnotationWebContext
extends XmlApplicationContext
implements WebContext {
    protected final Resource resource;
    protected final List<InterceptorMetaInfo> interceptorList = new LinkedList<InterceptorMetaInfo>();

    public AnnotationWebContext(String file) {
        super(file);
        this.resource = new Resource(this.getEncoding());
        this.initContext();
    }

    public AnnotationWebContext(String file, ServletContext servletContext) {
        this(file);
        if (servletContext != null) {
            TemplateView.init(servletContext.getRealPath(this.getViewPath()), this.getEncoding());
        }
    }

    private void initContext() {
        for (BeanDefinition beanDef : this.beanDefinitions) {
            AnnotationBeanDefinition beanDefinition;
            if (beanDef instanceof ControllerBeanDefinition) {
                beanDefinition = (ControllerBeanDefinition)beanDef;
                List<Method> list = beanDefinition.getReqMethods();
                if (list == null) continue;
                for (Method m : list) {
                    m.setAccessible(true);
                    String uri = m.getAnnotation(RequestMapping.class).value();
                    ControllerMetaInfo c = new ControllerMetaInfo(beanDefinition.getInjectedInstance(), m);
                    this.resource.add(uri, c);
                }
                continue;
            }
            if (!(beanDef instanceof InterceptorBeanDefinition) || (beanDefinition = (InterceptorBeanDefinition)beanDef).getDisposeMethod() == null) continue;
            beanDefinition.getDisposeMethod().setAccessible(true);
            InterceptorMetaInfo interceptor = new InterceptorMetaInfo(beanDefinition.getInjectedInstance(), beanDefinition.getDisposeMethod(), beanDefinition.getUriPattern(), beanDefinition.getOrder());
            this.interceptorList.add(interceptor);
        }
        if (this.interceptorList.size() > 0) {
            Collections.sort(this.interceptorList);
        }
        TextView.setEncoding(this.getEncoding());
        JsonView.setEncoding(this.getEncoding());
        JspView.setViewPath(this.getViewPath());
    }

    @Override
    protected List<BeanDefinition> getBeanDefinitions(String file) {
        List<BeanDefinition> list1 = new WebBeanReader(file).loadBeanDefinitions();
        List<BeanDefinition> list2 = new XmlBeanReader(file).loadBeanDefinitions();
        if (list1 != null && list2 != null) {
            list1.addAll(list2);
            return list1;
        }
        if (list1 != null) {
            return list1;
        }
        if (list2 != null) {
            return list2;
        }
        return null;
    }

    @Override
    public String getEncoding() {
        return ConfigReader.getInstance().getConfig().getEncoding();
    }

    @Override
    public String getViewPath() {
        return ConfigReader.getInstance().getConfig().getViewPath();
    }

    @Override
    public HandlerChain match(String uri, String servletURI) {
        HandlerChainImpl chain = new HandlerChainImpl();
        this.addInterceptor(uri, servletURI, chain);
        this.addLastHandler(uri, servletURI, chain);
        chain.init();
        return chain;
    }

    protected void addLastHandler(String uri, String servletURI, HandlerChainImpl chain) {
        if (servletURI == null) {
            return;
        }
        Resource.Result last = this.resource.match(servletURI);
        if (last != null) {
            chain.add(last);
        }
    }

    protected void addInterceptor(String uri, String servletURI, HandlerChainImpl chain) {
        if (servletURI == null) {
            return;
        }
        this.interceptorList.stream().filter(interceptor -> interceptor.getPattern().match(servletURI) != null).forEach(interceptor -> chain.add((request, response) -> interceptor.invoke(interceptor.getParameters(request, response, chain, null))));
    }

    protected class HandlerChainImpl
    implements HandlerChain {
        private List<WebHandler> list = new LinkedList<WebHandler>();
        private Iterator<WebHandler> iterator;

        protected HandlerChainImpl() {
        }

        public void add(WebHandler webHandler) {
            this.list.add(webHandler);
        }

        private void init() {
            if (this.list.size() == 0) {
                this.list.add((request, response) -> {
                    String msg = request.getRequestURI() + " not found";
                    SystemHtmlPage.responseSystemPage(request, response, AnnotationWebContext.this.getEncoding(), 404, msg);
                    return null;
                });
            }
            if (this.iterator == null) {
                this.iterator = this.list.iterator();
            }
        }

        @Override
        public View doNext(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
            if (this.iterator.hasNext()) {
                return this.iterator.next().invoke(request, response);
            }
            return null;
        }
    }
}

