/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.core.support.xml.parse;

import com.firefly.core.support.xml.ManagedMap;
import com.firefly.core.support.xml.ManagedValue;
import com.firefly.core.support.xml.XmlManagedNode;
import com.firefly.core.support.xml.parse.AbstractXmlNodeParser;
import com.firefly.core.support.xml.parse.XmlNodeParser;
import com.firefly.core.support.xml.parse.XmlNodeStateMachine;
import com.firefly.utils.dom.Dom;
import java.util.List;
import org.w3c.dom.Element;

public class MapNodeParser
extends AbstractXmlNodeParser
implements XmlNodeParser {
    @Override
    public Object parse(Element ele, Dom dom) {
        String typeName = ele.getAttribute("type");
        ManagedMap<ManagedValue, ManagedValue> target = new ManagedMap<ManagedValue, ManagedValue>();
        target.setTypeName(typeName);
        List elements = dom.elements(ele);
        for (Element entry : elements) {
            List keyEle;
            XmlManagedNode key = null;
            XmlManagedNode value = null;
            if (entry.hasAttribute("key")) {
                key = new ManagedValue(entry.getAttribute("key"));
            }
            if (entry.hasAttribute("value")) {
                value = new ManagedValue(entry.getAttribute("value"));
            }
            if ((keyEle = dom.elements(entry, "key")).size() > 1) {
                this.error("must not contain more than one key-element");
            } else if (keyEle.size() == 1) {
                if (key != null) {
                    this.error("only allowed to contain either 'key' attribute OR key-element");
                } else {
                    List subKey = dom.elements((Element)keyEle.get(0));
                    if (subKey.size() != 1) {
                        String keyText = dom.getTextValue((Element)keyEle.get(0));
                        if (keyText == null) {
                            this.error("must contain one key-sub-element");
                        } else {
                            key = new ManagedValue(keyText);
                        }
                    } else {
                        key = (XmlManagedNode)XmlNodeStateMachine.stateProcessor((Element)subKey.get(0), dom);
                    }
                }
            } else if (key == null) {
                this.error("not contain 'key' attribute OR key-element");
            }
            List valueEle = dom.elements(entry, "value");
            if (valueEle.size() > 1) {
                this.error("must not contain more than one value-element");
            } else if (valueEle.size() == 1) {
                if (value != null) {
                    this.error("only allowed to contain either 'value' attribute OR value-element");
                } else {
                    List subValue = dom.elements((Element)valueEle.get(0));
                    if (subValue.size() != 1) {
                        String valueText = dom.getTextValue((Element)valueEle.get(0));
                        if (valueText == null) {
                            this.error("must contain one value-sub-element");
                        } else {
                            value = new ManagedValue(valueText);
                        }
                    } else {
                        value = (XmlManagedNode)XmlNodeStateMachine.stateProcessor((Element)subValue.get(0), dom);
                    }
                }
            } else if (value == null) {
                this.error("not contain 'value' attribute OR value-element");
            }
            target.put((ManagedValue)key, (ManagedValue)value);
        }
        return target;
    }
}

