/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.core.support.xml.parse;

import com.firefly.core.support.xml.ManagedRef;
import com.firefly.core.support.xml.ManagedValue;
import com.firefly.core.support.xml.XmlBeanReader;
import com.firefly.core.support.xml.XmlGenericBeanDefinition;
import com.firefly.core.support.xml.XmlManagedNode;
import com.firefly.core.support.xml.parse.AbstractXmlNodeParser;
import com.firefly.core.support.xml.parse.XmlNodeParser;
import com.firefly.core.support.xml.parse.XmlNodeStateMachine;
import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.dom.Dom;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanNodeParser
extends AbstractXmlNodeParser
implements XmlNodeParser {
    @Override
    public Object parse(Element ele, Dom dom) {
        XmlManagedNode xmlManagedNode;
        List constructors;
        String destroyedMethod;
        String id = ele.getAttribute("id");
        String className = ele.getAttribute("class");
        XmlGenericBeanDefinition xmlBeanDefinition = new XmlGenericBeanDefinition();
        xmlBeanDefinition.setId(id);
        xmlBeanDefinition.setClassName(className);
        Class<?> clazz = null;
        log.info("classes [{}]", (Object)className);
        try {
            clazz = XmlBeanReader.class.getClassLoader().loadClass(className);
        }
        catch (Throwable e) {
            this.error("loads class \"" + className + "\" error");
        }
        String initMethod = ele.getAttribute("init-method");
        if (StringUtils.hasText((String)initMethod)) {
            try {
                Method method = clazz.getMethod(initMethod, new Class[0]);
                xmlBeanDefinition.setInitMethod(method);
            }
            catch (NoSuchMethodException | SecurityException e) {
                this.error("the initial method " + initMethod + " not found");
            }
        }
        if (StringUtils.hasText((String)(destroyedMethod = ele.getAttribute("destroy-method")))) {
            try {
                Method method = clazz.getMethod(destroyedMethod, new Class[0]);
                xmlBeanDefinition.setDestroyedMethod(method);
            }
            catch (NoSuchMethodException | SecurityException e) {
                this.error("the initial method " + initMethod + " not found");
            }
        }
        if ((constructors = dom.elements(ele, "constructor")) != null && constructors.size() > 0) {
            Element constructorElement = (Element)constructors.get(0);
            List arguments = dom.elements(constructorElement, "argument");
            if (arguments != null && arguments.size() >= 1) {
                ArrayList argsClass = new ArrayList();
                for (Element argument : arguments) {
                    String initArgsType;
                    xmlManagedNode = this.parseXmlManagedNode(argument, dom);
                    if (xmlManagedNode != null) {
                        xmlBeanDefinition.getContructorParameters().add(xmlManagedNode);
                    }
                    if (VerifyUtils.isNotEmpty((String)(initArgsType = argument.getAttribute("type")))) {
                        try {
                            argsClass.add(XmlBeanReader.class.getClassLoader().loadClass(initArgsType));
                        }
                        catch (ClassNotFoundException e) {
                            this.error("The '" + initArgsType + "' not found");
                        }
                        continue;
                    }
                    this.error("The '" + className + "' constructor argument node MUST has type attribute");
                }
                try {
                    xmlBeanDefinition.setConstructor(clazz.getConstructor(argsClass.toArray(new Class[0])));
                }
                catch (Throwable e) {
                    this.error("The '" + className + "' gets constructor error");
                }
            } else {
                this.error("The '" + className + "' constructor node MUST be more than one argument node!");
            }
        } else {
            try {
                xmlBeanDefinition.setConstructor(clazz.getConstructor(new Class[0]));
            }
            catch (Throwable e) {
                this.error("The '" + className + "' gets constructor error");
            }
        }
        String[] names = ReflectUtils.getInterfaceNames(clazz);
        xmlBeanDefinition.setInterfaceNames(names);
        log.debug("XML bean node parsing,  class name [{}], interface size [{}]", (Object)className, (Object)names.length);
        List properties = dom.elements(ele, "property");
        if (properties != null) {
            for (Element property : properties) {
                String name = property.getAttribute("name");
                xmlManagedNode = this.parseXmlManagedNode(property, dom);
                if (xmlManagedNode == null || !VerifyUtils.isNotEmpty((String)name)) continue;
                xmlBeanDefinition.getProperties().put(name, xmlManagedNode);
            }
        }
        return xmlBeanDefinition;
    }

    private XmlManagedNode parseXmlManagedNode(Element property, Dom dom) {
        boolean hasValueAttribute = property.hasAttribute("value");
        boolean hasRefAttribute = property.hasAttribute("ref");
        NodeList nl = property.getChildNodes();
        Element subElement = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            if (subElement != null) {
                this.error("This element must not contain more than one sub-element");
                continue;
            }
            subElement = (Element)node;
        }
        if (hasValueAttribute && hasRefAttribute || (hasValueAttribute || hasRefAttribute) && subElement != null) {
            this.error("This element is only allowed to contain either 'ref' attribute OR 'value' attribute OR sub-element");
        }
        if (hasValueAttribute) {
            String value = property.getAttribute("value");
            if (!StringUtils.hasText((String)value)) {
                this.error("This element contains empty 'value' attribute");
            }
            return new ManagedValue(value);
        }
        if (hasRefAttribute) {
            String ref = property.getAttribute("ref");
            if (!StringUtils.hasText((String)ref)) {
                this.error("This element contains empty 'ref' attribute");
            }
            return new ManagedRef(ref);
        }
        if (subElement != null) {
            return (XmlManagedNode)XmlNodeStateMachine.stateProcessor(subElement, dom);
        }
        this.error("This element must specify a ref or value");
        return null;
    }
}

