/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.core.support.xml;

import com.firefly.core.support.AbstractBeanReader;
import com.firefly.core.support.BeanDefinition;
import com.firefly.core.support.xml.parse.XmlNodeStateMachine;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.dom.DefaultDom;
import com.firefly.utils.dom.Dom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlBeanReader
extends AbstractBeanReader {
    public XmlBeanReader() {
        this(null);
    }

    public XmlBeanReader(String file) {
        this.beanDefinitions = new ArrayList();
        DefaultDom dom = new DefaultDom();
        HashSet<String> errorMemo = new HashSet<String>();
        ArrayList<Element> beansList = new ArrayList<Element>();
        this.parseXml((Dom)dom, file, beansList, errorMemo);
        if (beansList != null) {
            for (Element ele : beansList) {
                this.beanDefinitions.add((BeanDefinition)XmlNodeStateMachine.stateProcessor(ele, (Dom)dom));
            }
        }
    }

    private void parseXml(Dom dom, String file, List<Element> beansList, Set<String> errorMemo) {
        Document doc = dom.getDocument(file == null ? "firefly.xml" : file);
        Element root = dom.getRoot(doc);
        List list = dom.elements(root, "bean");
        List importList = dom.elements(root, "import");
        if (importList != null) {
            for (Element ele : importList) {
                if (ele.hasAttribute("resource")) {
                    String resource = ele.getAttribute("resource");
                    if (errorMemo.contains(resource)) {
                        this.error("disallow cyclic references between two XML files");
                        return;
                    }
                    if (VerifyUtils.isEmpty((String)resource)) {
                        this.error("resource cannot be null");
                        return;
                    }
                    errorMemo.add(resource);
                    this.parseXml(dom, resource, beansList, errorMemo);
                    continue;
                }
                this.error("has no resource attribute");
                return;
            }
        }
        beansList.addAll(list);
    }
}

