/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.core.support.annotation;

import com.firefly.core.support.annotation.Config;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.dom.DefaultDom;
import com.firefly.utils.dom.Dom;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigReader {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    public static final String DEFAULT_CONFIG_FILE = "firefly.xml";
    public static final String SCAN_ELEMENT = "component-scan";
    public static final String MVC_ELEMENT = "mvc";
    public static final String PACKAGE_ATTRIBUTE = "base-package";
    public static final String VIEW_PATH_ATTRIBUTE = "view-path";
    public static final String VIEW_ENCODING_ATTRIBUTE = "view-encoding";
    public static final String VIEW_TYPE_ATTRIBUTE = "view-type";
    private Config config = new Config();

    private ConfigReader() {
    }

    public static ConfigReader getInstance() {
        return Holder.instance;
    }

    public Config load(String file) {
        DefaultDom dom = new DefaultDom();
        Document doc = dom.getDocument(file == null ? DEFAULT_CONFIG_FILE : file);
        Element root = dom.getRoot(doc);
        this.load(root, (Dom)dom);
        return this.config;
    }

    public Config load(Element root, Dom dom) {
        List scanList = dom.elements(root, SCAN_ELEMENT);
        if (scanList != null) {
            LinkedList<String> paths = new LinkedList<String>();
            for (int i = 0; i < scanList.size(); ++i) {
                Element ele = (Element)scanList.get(i);
                String path = ele.getAttribute(PACKAGE_ATTRIBUTE);
                if (VerifyUtils.isEmpty((String)path)) continue;
                paths.add(path);
            }
            this.config.setPaths(paths.toArray(new String[0]));
        } else {
            this.config.setPaths(new String[0]);
        }
        Element mvc = dom.element(root, MVC_ELEMENT);
        if (mvc != null) {
            String viewPath = mvc.getAttribute(VIEW_PATH_ATTRIBUTE);
            String encoding = mvc.getAttribute(VIEW_ENCODING_ATTRIBUTE);
            log.info("the MVC view path is {}, the encoding is {}", (Object)viewPath, (Object)encoding);
            if (VerifyUtils.isNotEmpty((String)viewPath)) {
                this.config.setViewPath(viewPath);
            }
            if (VerifyUtils.isNotEmpty((String)encoding)) {
                this.config.setEncoding(encoding);
            }
        }
        return this.config;
    }

    public Config getConfig() {
        return this.config;
    }

    private static class Holder {
        private static ConfigReader instance = new ConfigReader();

        private Holder() {
        }
    }
}

