/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.core.support.annotation;

import com.firefly.annotation.Component;
import com.firefly.annotation.DestroyedMethod;
import com.firefly.annotation.InitialMethod;
import com.firefly.annotation.Inject;
import com.firefly.core.support.AbstractBeanReader;
import com.firefly.core.support.BeanDefinition;
import com.firefly.core.support.annotation.AnnotatedBeanDefinition;
import com.firefly.core.support.annotation.Config;
import com.firefly.core.support.annotation.ConfigReader;
import com.firefly.utils.ReflectUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationBeanReader
extends AbstractBeanReader {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public AnnotationBeanReader() {
        this(null);
    }

    public AnnotationBeanReader(String file) {
        this.beanDefinitions = new ArrayList();
        Config config = ConfigReader.getInstance().load(file);
        for (String pack : config.getPaths()) {
            log.info("componentPath [{}]", (Object)pack);
            this.scan(pack.trim());
        }
    }

    private void scan(String packageName) {
        String packageDirName = packageName.replace('.', '/');
        log.debug("package directory name -> {} ", (Object)packageDirName);
        URL url = AnnotationBeanReader.class.getClassLoader().getResource(packageDirName);
        if (url == null) {
            this.error(packageName + " can not be found");
        }
        log.debug("URL -> {}", (Object)url.toString());
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            this.parseFile(url, packageDirName);
        } else if ("jar".equals(protocol)) {
            this.parseJar(url, packageDirName);
        }
    }

    private void parseFile(URL url, String packageDirName) {
        File path = null;
        try {
            path = new File(url.toURI());
        }
        catch (Throwable t) {
            log.error("parse file error", t);
        }
        path.listFiles(file -> {
            String name = file.getName();
            if (name.endsWith(".class") && !name.contains("$")) {
                this.parseClass(packageDirName.replace('/', '.') + "." + name.substring(0, file.getName().length() - 6));
            } else if (file.isDirectory()) {
                try {
                    this.parseFile(file.toURI().toURL(), packageDirName + "/" + name);
                }
                catch (Throwable t) {
                    log.error("parse file error", t);
                }
            }
            return false;
        });
    }

    private void parseJar(URL url, String packageDirName) {
        Enumeration<JarEntry> entries = null;
        try {
            entries = ((JarURLConnection)url.openConnection()).getJarFile().entries();
        }
        catch (Throwable t) {
            log.error("parse jar error", t);
        }
        while (entries.hasMoreElements()) {
            String name = entries.nextElement().getName();
            if (!name.endsWith(".class") || name.contains("$") || !name.startsWith(packageDirName + "/")) continue;
            this.parseClass(name.substring(0, name.length() - 6).replace('/', '.'));
        }
    }

    private void parseClass(String className) {
        Class<?> c = null;
        try {
            c = AnnotationBeanReader.class.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            log.error("parse class error", t);
        }
        BeanDefinition beanDefinition = this.getBeanDefinition(c);
        if (beanDefinition != null) {
            this.beanDefinitions.add(beanDefinition);
        }
    }

    protected BeanDefinition getBeanDefinition(Class<?> c) {
        if (c.isAnnotationPresent(Component.class)) {
            log.info("classes [{}]", (Object)c.getName());
            return this.componentParser(c);
        }
        return null;
    }

    protected BeanDefinition componentParser(Class<?> c) {
        AnnotatedBeanDefinition annotationBeanDefinition = new AnnotatedBeanDefinition();
        annotationBeanDefinition.setClassName(c.getName());
        annotationBeanDefinition.setId(c.getAnnotation(Component.class).value());
        annotationBeanDefinition.setInterfaceNames(ReflectUtils.getInterfaceNames(c));
        annotationBeanDefinition.setInjectFields(this.getInjectField(c));
        annotationBeanDefinition.setInjectMethods(this.getInjectMethod(c));
        annotationBeanDefinition.setConstructor(this.getInjectConstructor(c));
        annotationBeanDefinition.setInitMethod(this.getInitMethod(c));
        annotationBeanDefinition.setDestroyedMethod(this.getDestroyedMethod(c));
        return annotationBeanDefinition;
    }

    protected Method getDestroyedMethod(Class<?> c) {
        Method[] methods;
        for (Method m : methods = c.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(DestroyedMethod.class)) continue;
            return m;
        }
        return null;
    }

    protected Method getInitMethod(Class<?> c) {
        Method[] methods;
        for (Method m : methods = c.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(InitialMethod.class)) continue;
            return m;
        }
        return null;
    }

    protected Constructor<?> getInjectConstructor(Class<?> c) {
        for (Constructor<?> constructor : c.getConstructors()) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return constructor;
        }
        try {
            return c.getConstructor(new Class[0]);
        }
        catch (Throwable t) {
            log.error("gets non-parameter constructor error", t);
            return null;
        }
    }

    protected List<Field> getInjectField(Class<?> c) {
        Field[] fields = c.getDeclaredFields();
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : fields) {
            if (field.getAnnotation(Inject.class) == null) continue;
            list.add(field);
        }
        return list;
    }

    protected List<Method> getInjectMethod(Class<?> c) {
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : methods) {
            if (!m.isAnnotationPresent(Inject.class)) continue;
            list.add(m);
        }
        return list;
    }
}

