/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.core;

import com.firefly.annotation.Inject;
import com.firefly.core.AbstractApplicationContext;
import com.firefly.core.support.BeanDefinition;
import com.firefly.core.support.annotation.AnnotationBeanDefinition;
import com.firefly.core.support.annotation.AnnotationBeanReader;
import com.firefly.core.support.xml.ManagedArray;
import com.firefly.core.support.xml.ManagedList;
import com.firefly.core.support.xml.ManagedMap;
import com.firefly.core.support.xml.ManagedRef;
import com.firefly.core.support.xml.ManagedValue;
import com.firefly.core.support.xml.XmlBeanDefinition;
import com.firefly.core.support.xml.XmlBeanReader;
import com.firefly.core.support.xml.XmlManagedNode;
import com.firefly.utils.ConvertUtils;
import com.firefly.utils.ReflectUtils;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlApplicationContext
extends AbstractApplicationContext {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");

    public XmlApplicationContext() {
        this(null);
    }

    public XmlApplicationContext(String file) {
        super(file);
    }

    @Override
    protected List<BeanDefinition> getBeanDefinitions(String file) {
        List<BeanDefinition> list1 = new AnnotationBeanReader(file).loadBeanDefinitions();
        List<BeanDefinition> list2 = new XmlBeanReader(file).loadBeanDefinitions();
        if (list1 != null && list2 != null) {
            log.debug("mixed bean");
            list1.addAll(list2);
            return list1;
        }
        if (list1 != null) {
            log.debug("annotation bean");
            return list1;
        }
        if (list2 != null) {
            log.debug("xml bean");
            return list2;
        }
        return null;
    }

    @Override
    protected Object inject(BeanDefinition beanDef) {
        if (beanDef instanceof XmlBeanDefinition) {
            return this.xmlInject(beanDef);
        }
        if (beanDef instanceof AnnotationBeanDefinition) {
            return this.annotationInject(beanDef);
        }
        return null;
    }

    private Object getInstance(BeanDefinition beanDef) {
        String[] keys;
        if (StringUtils.hasText((String)beanDef.getId())) {
            return this.map.get(beanDef.getId());
        }
        Object instance = this.map.get(beanDef.getClassName());
        if (instance != null) {
            return instance;
        }
        for (String k : keys = beanDef.getInterfaceNames()) {
            instance = this.map.get(beanDef);
            if (instance == null) continue;
            return instance;
        }
        return instance;
    }

    private Object xmlInject(BeanDefinition beanDef) {
        Object instance = this.getInstance(beanDef);
        if (instance == null) {
            XmlBeanDefinition beanDefinition = (XmlBeanDefinition)beanDef;
            Class<?> clazz = null;
            try {
                clazz = XmlApplicationContext.class.getClassLoader().loadClass(beanDefinition.getClassName());
                if (beanDefinition.getContructorParameters().size() <= 0) {
                    instance = clazz.newInstance();
                } else {
                    ArrayList<Object> constructorParameters = new ArrayList<Object>();
                    for (int i = 0; i < beanDefinition.getContructorParameters().size(); ++i) {
                        Object p = this.getInjectArg(beanDefinition.getContructorParameters().get(i), beanDefinition.getConstructor().getParameterTypes()[i]);
                        constructorParameters.add(p);
                    }
                    instance = beanDefinition.getConstructor().newInstance(constructorParameters.toArray());
                }
            }
            catch (Throwable t) {
                log.error("object initiate error", t);
            }
            if (instance != null) {
                Object obj = instance;
                ReflectUtils.getSetterMethods(clazz, (propertyName, method) -> {
                    XmlManagedNode value = beanDefinition.getProperties().get(propertyName);
                    if (value != null) {
                        try {
                            method.invoke(obj, this.getInjectArg(value, method.getParameterTypes()[0]));
                        }
                        catch (Throwable t) {
                            log.error("xml inject error", t);
                        }
                    }
                    return false;
                });
            } else {
                this.error("initialize XML bean exception, the instance is null");
            }
            this.addObjectToContext(beanDefinition, instance);
            return instance;
        }
        return instance;
    }

    private Object getInjectArg(XmlManagedNode value, Class<?> parameterType) {
        if (value instanceof ManagedValue) {
            ManagedValue managedValue = (ManagedValue)value;
            String typeName = null;
            typeName = parameterType == null ? (VerifyUtils.isEmpty((String)managedValue.getTypeName()) ? null : managedValue.getTypeName()) : (VerifyUtils.isEmpty((String)managedValue.getTypeName()) ? parameterType.getName() : managedValue.getTypeName());
            log.debug("value type [{}]", (Object)typeName);
            return this.getValueArg(managedValue, typeName);
        }
        if (value instanceof ManagedRef) {
            return this.getRefArg((ManagedRef)value);
        }
        if (value instanceof ManagedList) {
            return this.getListArg((ManagedList)value, parameterType);
        }
        if (value instanceof ManagedArray) {
            return this.getArrayArg((ManagedArray)value, parameterType);
        }
        if (value instanceof ManagedMap) {
            return this.getMapArg((ManagedMap)value, parameterType);
        }
        return null;
    }

    private Object getValueArg(ManagedValue managedValue, String typeName) {
        return ConvertUtils.convert((String)managedValue.getValue(), (String)typeName);
    }

    private Object getRefArg(ManagedRef ref) {
        BeanDefinition b;
        Object instance = this.map.get(ref.getBeanName());
        if (instance == null && (b = this.findBeanDefinition(ref.getBeanName())) != null) {
            instance = this.inject(b);
        }
        return instance;
    }

    private Object getListArg(ManagedList<XmlManagedNode> values, Class<?> setterParamType) {
        Collection<Object> collection = null;
        if (VerifyUtils.isNotEmpty((String)values.getTypeName())) {
            try {
                collection = (Collection)XmlApplicationContext.class.getClassLoader().loadClass(values.getTypeName()).newInstance();
            }
            catch (Throwable t) {
                log.error("list inject error", t);
            }
        } else {
            collection = setterParamType == null ? new ArrayList() : ConvertUtils.getCollectionObj(setterParamType);
        }
        for (XmlManagedNode item : values) {
            Object listValue = this.getInjectArg(item, null);
            collection.add(listValue);
        }
        return collection;
    }

    private Object getArrayArg(ManagedArray<XmlManagedNode> values, Class<?> setterParamType) {
        ArrayList<Object> collection = new ArrayList<Object>();
        for (XmlManagedNode item : values) {
            Object listValue = this.getInjectArg(item, null);
            collection.add(listValue);
        }
        return ConvertUtils.convert(collection, setterParamType);
    }

    private Object getMapArg(ManagedMap<XmlManagedNode, XmlManagedNode> values, Class<?> setterParamType) {
        Map<Object, Object> m = null;
        if (VerifyUtils.isNotEmpty((String)values.getTypeName())) {
            try {
                m = (Map)XmlApplicationContext.class.getClassLoader().loadClass(values.getTypeName()).newInstance();
            }
            catch (Throwable t) {
                log.error("map inject error", t);
            }
        } else {
            m = setterParamType == null ? new HashMap() : ConvertUtils.getMapObj(setterParamType);
            log.debug("map ret [{}]", (Object)m.getClass().getName());
        }
        for (XmlManagedNode o : values.keySet()) {
            Object k = this.getInjectArg(o, null);
            Object v = this.getInjectArg((XmlManagedNode)values.get(o), null);
            m.put(k, v);
        }
        return m;
    }

    private Object annotationInject(BeanDefinition beanDef) {
        Object instance = this.getInstance(beanDef);
        if (instance == null) {
            AnnotationBeanDefinition beanDefinition = (AnnotationBeanDefinition)beanDef;
            instance = this.constructorInject(beanDefinition);
            beanDefinition.setInjectedInstance(instance);
            this.fieldInject(beanDefinition, instance);
            this.methodInject(beanDefinition, instance);
            this.addObjectToContext(beanDefinition, instance);
            return instance;
        }
        return instance;
    }

    private Object constructorInject(AnnotationBeanDefinition beanDefinition) {
        Class<?>[] params = beanDefinition.getConstructor().getParameterTypes();
        Object[] p = new Object[params.length];
        this.injectObject(params, p);
        Object instance = null;
        try {
            instance = beanDefinition.getConstructor().newInstance(p);
        }
        catch (Throwable t) {
            log.error("constructor injecting error", t);
        }
        return instance;
    }

    private void injectObject(Class<?>[] params, Object[] p) {
        for (int i = 0; i < p.length; ++i) {
            String key = params[i].getName();
            Object instance = this.map.get(key);
            if (instance != null) {
                p[i] = instance;
                continue;
            }
            BeanDefinition b = this.findBeanDefinition(key);
            if (b == null) continue;
            p[i] = this.inject(b);
        }
    }

    private void fieldInject(AnnotationBeanDefinition beanDefinition, Object object) {
        for (Field field : beanDefinition.getInjectFields()) {
            BeanDefinition b;
            field.setAccessible(true);
            Class<?> clazz = field.getType();
            String id = field.getAnnotation(Inject.class).value();
            String key = VerifyUtils.isNotEmpty((String)id) ? id : clazz.getName();
            Object instance = this.map.get(key);
            if (instance == null && (b = this.findBeanDefinition(key)) != null) {
                instance = this.inject(b);
            }
            if (instance == null) continue;
            try {
                field.set(object, instance);
            }
            catch (Throwable t) {
                log.error("field injecting error", t);
            }
        }
    }

    private void methodInject(AnnotationBeanDefinition beanDefinition, Object object) {
        for (Method method : beanDefinition.getInjectMethods()) {
            method.setAccessible(true);
            Class<?>[] params = method.getParameterTypes();
            Object[] p = new Object[params.length];
            this.injectObject(params, p);
            try {
                method.invoke(object, p);
            }
            catch (Throwable t) {
                log.error("method injecting error", t);
            }
        }
    }
}

