/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.core;

import com.firefly.core.ApplicationContext;
import com.firefly.core.support.BeanDefinition;
import com.firefly.core.support.exception.BeanDefinitionParsingException;
import com.firefly.utils.VerifyUtils;
import com.firefly.utils.lang.Pair;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationContext
implements ApplicationContext {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected Map<String, Object> map = new HashMap<String, Object>();
    protected Set<String> errorMemo = new HashSet<String>();
    protected List<BeanDefinition> beanDefinitions;
    protected List<Pair<Method, Object>> destroyedMethods = new ArrayList<Pair<Method, Object>>();
    protected List<Pair<Method, Object>> initMethods = new ArrayList<Pair<Method, Object>>();

    public AbstractApplicationContext() {
        this(null);
    }

    public AbstractApplicationContext(String file) {
        this.beanDefinitions = this.getBeanDefinitions(file);
        this.check();
        this.addObjectToContext();
        if (!this.initMethods.isEmpty()) {
            this.initMethods.forEach(pair -> {
                try {
                    ((Method)pair.first).invoke(pair.second, new Object[0]);
                }
                catch (Exception e) {
                    this.error("invoke initial method error, " + e.getMessage());
                }
            });
        }
        if (!this.destroyedMethods.isEmpty()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.destroyedMethods.forEach(pair -> {
                try {
                    ((Method)pair.first).invoke(pair.second, new Object[0]);
                }
                catch (Exception e) {
                    log.error("invoke destroyed method exception", (Throwable)e);
                }
            }), "the firefly shutdown thead"));
        }
    }

    private void addObjectToContext() {
        for (BeanDefinition beanDefinition : this.beanDefinitions) {
            this.inject(beanDefinition);
        }
    }

    @Override
    public <T> T getBean(Class<T> clazz) {
        return (T)this.map.get(clazz.getName());
    }

    @Override
    public <T> T getBean(String id) {
        return (T)this.map.get(id);
    }

    protected void check() {
        for (int i = 0; i < this.beanDefinitions.size(); ++i) {
            for (int j = i + 1; j < this.beanDefinitions.size(); ++j) {
                log.debug("check bean " + i + "|" + j);
                BeanDefinition b1 = this.beanDefinitions.get(i);
                BeanDefinition b2 = this.beanDefinitions.get(j);
                if (VerifyUtils.isNotEmpty((String)b1.getId()) && VerifyUtils.isNotEmpty((String)b2.getId()) && b1.getId().equals(b2.getId())) {
                    this.error("bean " + b1.getClassName() + " and bean " + b2.getClassName() + " have duplicate id ");
                }
                if (b1.getClassName().equals(b2.getClassName())) {
                    if (VerifyUtils.isEmpty((String)b1.getId()) || VerifyUtils.isEmpty((String)b2.getId())) {
                        this.error("class " + b1.getClassName() + " duplicate definition");
                    } else {
                        this.errorMemo.add(b1.getClassName());
                    }
                }
                for (String iname1 : b1.getInterfaceNames()) {
                    for (String iname2 : b2.getInterfaceNames()) {
                        if (!iname1.equals(iname2)) continue;
                        if (VerifyUtils.isEmpty((String)b1.getId()) || VerifyUtils.isEmpty((String)b2.getId())) {
                            this.error("class " + b1.getClassName() + " duplicate definition");
                            continue;
                        }
                        this.errorMemo.add(iname1);
                    }
                }
            }
        }
    }

    protected void check(String key) {
        if (this.errorMemo.contains(key)) {
            this.error(key + " auto inject failure!");
        }
    }

    protected void addObjectToContext(BeanDefinition beanDefinition, Object object) {
        Method destroyedMethod;
        Method initMethod;
        String[] keys;
        String id = beanDefinition.getId();
        if (VerifyUtils.isNotEmpty((String)id)) {
            this.map.put(id, object);
        }
        this.map.put(beanDefinition.getClassName(), object);
        for (String k : keys = beanDefinition.getInterfaceNames()) {
            this.map.put(k, object);
        }
        if (log.isDebugEnabled()) {
            log.debug("add object [{}] - [{}] to context", beanDefinition.getClass(), (Object)object.toString());
        }
        if ((initMethod = beanDefinition.getInitMethod()) != null) {
            Pair pair = new Pair((Object)initMethod, object);
            this.initMethods.add((Pair<Method, Object>)pair);
        }
        if ((destroyedMethod = beanDefinition.getDestroyedMethod()) != null) {
            Pair pair = new Pair((Object)destroyedMethod, object);
            this.destroyedMethods.add((Pair<Method, Object>)pair);
        }
    }

    protected BeanDefinition findBeanDefinition(String key) {
        this.check(key);
        for (BeanDefinition beanDefinition : this.beanDefinitions) {
            if (key.equals(beanDefinition.getId())) {
                return beanDefinition;
            }
            if (key.equals(beanDefinition.getClassName())) {
                return beanDefinition;
            }
            for (String interfaceName : beanDefinition.getInterfaceNames()) {
                if (!key.equals(interfaceName)) continue;
                return beanDefinition;
            }
        }
        return null;
    }

    protected void error(String msg) {
        log.error(msg);
        throw new BeanDefinitionParsingException(msg);
    }

    protected abstract List<BeanDefinition> getBeanDefinitions(String var1);

    protected abstract Object inject(BeanDefinition var1);
}

