/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.stream.AbstractFlowControlStrategy;
import com.firefly.codec.http2.stream.SessionSPI;
import com.firefly.codec.http2.stream.StreamSPI;
import com.firefly.utils.concurrent.Callback;

public class SimpleFlowControlStrategy
extends AbstractFlowControlStrategy {
    public SimpleFlowControlStrategy() {
        this(65535);
    }

    public SimpleFlowControlStrategy(int initialStreamSendWindow) {
        super(initialStreamSendWindow);
    }

    @Override
    public void onDataConsumed(SessionSPI session, StreamSPI stream, int length) {
        if (length <= 0) {
            return;
        }
        WindowUpdateFrame sessionFrame = new WindowUpdateFrame(0, length);
        session.updateRecvWindow(length);
        if (log.isDebugEnabled()) {
            log.debug("Data consumed, increased session recv window by {} for {}", (Object)length, (Object)session);
        }
        Frame[] streamFrame = Frame.EMPTY_ARRAY;
        if (stream != null) {
            if (stream.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug("Data consumed, ignoring update stream recv window by {} for closed {}", (Object)length, (Object)stream);
                }
            } else {
                streamFrame = new Frame[]{new WindowUpdateFrame(stream.getId(), length)};
                stream.updateRecvWindow(length);
                if (log.isDebugEnabled()) {
                    log.debug("Data consumed, increased stream recv window by {} for {}", (Object)length, (Object)stream);
                }
            }
        }
        session.frames(stream, Callback.NOOP, sessionFrame, streamFrame);
    }
}

