/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.frame.GoAwayFrame;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PingFrame;
import com.firefly.codec.http2.frame.PriorityFrame;
import com.firefly.codec.http2.frame.ResetFrame;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.Promise;
import java.util.Collection;
import java.util.Map;

public interface Session {
    public void newStream(HeadersFrame var1, Promise<Stream> var2, Stream.Listener var3);

    public int priority(PriorityFrame var1, Callback var2);

    public void settings(SettingsFrame var1, Callback var2);

    public void ping(PingFrame var1, Callback var2);

    public boolean close(int var1, String var2, Callback var3);

    public boolean isClosed();

    public Collection<Stream> getStreams();

    public Stream getStream(int var1);

    public static interface Listener {
        public Map<Integer, Integer> onPreface(Session var1);

        public Stream.Listener onNewStream(Stream var1, HeadersFrame var2);

        public void onSettings(Session var1, SettingsFrame var2);

        public void onPing(Session var1, PingFrame var2);

        public void onReset(Session var1, ResetFrame var2);

        public void onClose(Session var1, GoAwayFrame var2);

        public boolean onIdleTimeout(Session var1);

        public void onFailure(Session var1, Throwable var2);

        public static class Adapter
        implements Listener {
            @Override
            public Map<Integer, Integer> onPreface(Session session) {
                return null;
            }

            @Override
            public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
                return null;
            }

            @Override
            public void onSettings(Session session, SettingsFrame frame) {
            }

            @Override
            public void onPing(Session session, PingFrame frame) {
            }

            @Override
            public void onReset(Session session, ResetFrame frame) {
            }

            @Override
            public void onClose(Session session, GoAwayFrame frame) {
            }

            @Override
            public boolean onIdleTimeout(Session session) {
                return true;
            }

            @Override
            public void onFailure(Session session, Throwable failure) {
            }
        }
    }
}

