/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.model.MetaData;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPOutputStream
extends OutputStream {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected final boolean clientMode;
    protected final MetaData info;
    protected boolean closed;
    protected boolean commited;

    public HTTPOutputStream(MetaData info, boolean clientMode) {
        this.info = info;
        this.clientMode = clientMode;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized boolean isCommited() {
        return this.commited;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] array, int offset, int length) throws IOException {
        this.write(ByteBuffer.wrap(array, offset, length));
    }

    public abstract void writeWithContentLength(ByteBuffer[] var1) throws IOException;

    public abstract void writeWithContentLength(ByteBuffer var1) throws IOException;

    public abstract void commit() throws IOException;

    public abstract void write(ByteBuffer var1) throws IOException;
}

