/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.utils.function.Action4;
import com.firefly.utils.function.Action6;
import com.firefly.utils.function.Func4;
import com.firefly.utils.function.Func5;
import java.nio.ByteBuffer;

public interface HTTPHandler {
    public boolean content(ByteBuffer var1, MetaData.Request var2, MetaData.Response var3, HTTPOutputStream var4, HTTPConnection var5);

    public boolean contentComplete(MetaData.Request var1, MetaData.Response var2, HTTPOutputStream var3, HTTPConnection var4);

    public boolean headerComplete(MetaData.Request var1, MetaData.Response var2, HTTPOutputStream var3, HTTPConnection var4);

    public boolean messageComplete(MetaData.Request var1, MetaData.Response var2, HTTPOutputStream var3, HTTPConnection var4);

    public void badMessage(int var1, String var2, MetaData.Request var3, MetaData.Response var4, HTTPOutputStream var5, HTTPConnection var6);

    public void earlyEOF(MetaData.Request var1, MetaData.Response var2, HTTPOutputStream var3, HTTPConnection var4);

    public static class Adapter
    implements HTTPHandler {
        protected Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> headerComplete;
        protected Func5<ByteBuffer, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> content;
        protected Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> contentComplete;
        protected Func4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection, Boolean> messageComplete;
        protected Action6<Integer, String, MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection> badMessage;
        protected Action4<MetaData.Request, MetaData.Response, HTTPOutputStream, HTTPConnection> earlyEOF;

        @Override
        public boolean headerComplete(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
            if (this.headerComplete != null) {
                return (Boolean)this.headerComplete.call((Object)request, (Object)response, (Object)output, (Object)connection);
            }
            return false;
        }

        @Override
        public boolean content(ByteBuffer item, MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
            if (this.content != null) {
                return (Boolean)this.content.call((Object)item, (Object)request, (Object)response, (Object)output, (Object)connection);
            }
            return false;
        }

        @Override
        public boolean contentComplete(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
            if (this.contentComplete != null) {
                return (Boolean)this.contentComplete.call((Object)request, (Object)response, (Object)output, (Object)connection);
            }
            return false;
        }

        @Override
        public boolean messageComplete(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
            if (this.messageComplete != null) {
                return (Boolean)this.messageComplete.call((Object)request, (Object)response, (Object)output, (Object)connection);
            }
            return true;
        }

        @Override
        public void badMessage(int status, String reason, MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
            if (this.badMessage != null) {
                this.badMessage.call((Object)status, (Object)reason, (Object)request, (Object)response, (Object)output, (Object)connection);
            }
        }

        @Override
        public void earlyEOF(MetaData.Request request, MetaData.Response response, HTTPOutputStream output, HTTPConnection connection) {
            if (this.earlyEOF != null) {
                this.earlyEOF.call((Object)request, (Object)response, (Object)output, (Object)connection);
            }
        }
    }
}

