/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PushPromiseFrame;
import com.firefly.codec.http2.frame.ResetFrame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.stream.CloseState;
import com.firefly.codec.http2.stream.SessionSPI;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.codec.http2.stream.StreamSPI;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.IdleTimeout;
import com.firefly.utils.concurrent.Promise;
import com.firefly.utils.concurrent.Scheduler;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.WritePendingException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2Stream
extends IdleTimeout
implements StreamSPI,
Callback {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final AtomicReference<ConcurrentMap<String, Object>> attributes = new AtomicReference();
    private final AtomicReference<CloseState> closeState = new AtomicReference<CloseState>(CloseState.NOT_CLOSED);
    private final AtomicReference<Callback> writing = new AtomicReference();
    private final AtomicInteger sendWindow = new AtomicInteger();
    private final AtomicInteger recvWindow = new AtomicInteger();
    private final SessionSPI session;
    private final int streamId;
    private final boolean local;
    private volatile Stream.Listener listener;
    private volatile boolean localReset;
    private volatile boolean remoteReset;

    public HTTP2Stream(Scheduler scheduler, SessionSPI session, int streamId, boolean local) {
        super(scheduler);
        this.session = session;
        this.streamId = streamId;
        this.local = local;
    }

    @Override
    public int getId() {
        return this.streamId;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public SessionSPI getSession() {
        return this.session;
    }

    @Override
    public void headers(HeadersFrame frame, Callback callback) {
        if (!this.checkWrite(callback)) {
            return;
        }
        this.session.frames(this, this, frame, Frame.EMPTY_ARRAY);
    }

    @Override
    public void push(PushPromiseFrame frame, Promise<Stream> promise, Stream.Listener listener) {
        this.session.push(this, promise, frame, listener);
    }

    @Override
    public void data(DataFrame frame, Callback callback) {
        if (!this.checkWrite(callback)) {
            return;
        }
        this.session.data(this, this, frame);
    }

    @Override
    public void reset(ResetFrame frame, Callback callback) {
        if (this.isReset()) {
            return;
        }
        this.localReset = true;
        this.session.frames(this, callback, frame, Frame.EMPTY_ARRAY);
    }

    private boolean checkWrite(Callback callback) {
        if (this.writing.compareAndSet(null, callback)) {
            return true;
        }
        callback.failed((Throwable)new WritePendingException());
        return false;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes().get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes().put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes().remove(key);
    }

    @Override
    public boolean isReset() {
        return this.localReset || this.remoteReset;
    }

    @Override
    public boolean isClosed() {
        return this.closeState.get() == CloseState.CLOSED;
    }

    public boolean isRemotelyClosed() {
        return this.closeState.get() == CloseState.REMOTELY_CLOSED;
    }

    public boolean isLocallyClosed() {
        return this.closeState.get() == CloseState.LOCALLY_CLOSED;
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    protected void onIdleExpired(TimeoutException timeout) {
        if (log.isDebugEnabled()) {
            log.debug("Idle timeout {}ms expired on {}", (Object)this.getIdleTimeout(), (Object)this);
        }
        if (this.notifyIdleTimeout(this, timeout)) {
            this.reset(new ResetFrame(this.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
        }
    }

    private ConcurrentMap<String, Object> attributes() {
        ConcurrentMap<String, Object> map = this.attributes.get();
        if (map == null && !this.attributes.compareAndSet(null, map = new ConcurrentHashMap<String, Object>())) {
            map = this.attributes.get();
        }
        return map;
    }

    @Override
    public Stream.Listener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(Stream.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void process(Frame frame, Callback callback) {
        this.notIdle();
        switch (frame.getType()) {
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame, callback);
                break;
            }
            case DATA: {
                this.onData((DataFrame)frame, callback);
                break;
            }
            case RST_STREAM: {
                this.onReset((ResetFrame)frame, callback);
                break;
            }
            case PUSH_PROMISE: {
                this.onPush((PushPromiseFrame)frame, callback);
                break;
            }
            case WINDOW_UPDATE: {
                this.onWindowUpdate((WindowUpdateFrame)frame, callback);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void onHeaders(HeadersFrame frame, Callback callback) {
        if (this.updateClose(frame.isEndStream(), false)) {
            this.session.removeStream(this);
        }
        callback.succeeded();
    }

    private void onData(DataFrame frame, Callback callback) {
        if (this.getRecvWindow() < 0) {
            this.session.close(ErrorCode.FLOW_CONTROL_ERROR.code, "stream_window_exceeded", Callback.NOOP);
            callback.failed((Throwable)new IOException("stream_window_exceeded"));
            return;
        }
        if (this.isRemotelyClosed()) {
            this.reset(new ResetFrame(this.streamId, ErrorCode.STREAM_CLOSED_ERROR.code), Callback.NOOP);
            callback.failed((Throwable)new EOFException("stream_closed"));
            return;
        }
        if (this.isReset()) {
            callback.failed((Throwable)new IOException("stream_reset"));
            return;
        }
        if (this.updateClose(frame.isEndStream(), false)) {
            this.session.removeStream(this);
        }
        this.notifyData(this, frame, callback);
    }

    private void onReset(ResetFrame frame, Callback callback) {
        this.remoteReset = true;
        this.close();
        this.session.removeStream(this);
        callback.succeeded();
        this.notifyReset(this, frame);
    }

    private void onPush(PushPromiseFrame frame, Callback callback) {
        this.updateClose(true, true);
        callback.succeeded();
    }

    private void onWindowUpdate(WindowUpdateFrame frame, Callback callback) {
        callback.succeeded();
    }

    @Override
    public boolean updateClose(boolean update, boolean local) {
        if (log.isDebugEnabled()) {
            log.debug("Update close for {} close={} local={}", new Object[]{this, update, local});
        }
        if (!update) {
            return false;
        }
        block5: while (true) {
            CloseState current = this.closeState.get();
            switch (current) {
                case NOT_CLOSED: {
                    CloseState newValue;
                    if (!this.closeState.compareAndSet(current, newValue = local ? CloseState.LOCALLY_CLOSED : CloseState.REMOTELY_CLOSED)) continue block5;
                    return false;
                }
                case LOCALLY_CLOSED: {
                    if (local) {
                        return false;
                    }
                    this.close();
                    return true;
                }
                case REMOTELY_CLOSED: {
                    if (!local) {
                        return false;
                    }
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public int getSendWindow() {
        return this.sendWindow.get();
    }

    public int getRecvWindow() {
        return this.recvWindow.get();
    }

    @Override
    public int updateSendWindow(int delta) {
        return this.sendWindow.getAndAdd(delta);
    }

    @Override
    public int updateRecvWindow(int delta) {
        return this.recvWindow.getAndAdd(delta);
    }

    @Override
    public void close() {
        this.closeState.set(CloseState.CLOSED);
        this.onClose();
    }

    public void succeeded() {
        Callback callback = this.writing.getAndSet(null);
        callback.succeeded();
    }

    public void failed(Throwable x) {
        Callback callback = this.writing.getAndSet(null);
        callback.failed(x);
    }

    private void notifyData(Stream stream, DataFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onData(stream, frame, callback);
        }
        catch (Throwable x) {
            log.info("Failure while notifying listener " + listener, x);
        }
    }

    private void notifyReset(Stream stream, ResetFrame frame) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onReset(stream, frame);
        }
        catch (Throwable x) {
            log.info("Failure while notifying listener " + listener, x);
        }
    }

    private boolean notifyIdleTimeout(Stream stream, Throwable failure) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return true;
        }
        try {
            return listener.onIdleTimeout(stream, failure);
        }
        catch (Throwable x) {
            log.info("Failure while notifying listener " + listener, x);
            return true;
        }
    }

    public String toString() {
        return String.format("%s@%x#%d{sendWindow=%s,recvWindow=%s,reset=%b,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getId(), this.sendWindow, this.recvWindow, this.isReset(), this.closeState);
    }
}

