/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.stream.FlowControlStrategy;
import com.firefly.codec.http2.stream.HTTP2Session;
import com.firefly.codec.http2.stream.StreamSPI;
import com.firefly.net.ByteBufferArrayOutputEntry;
import com.firefly.utils.concurrent.Callback;
import com.firefly.utils.concurrent.IteratingCallback;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.io.EofException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2Flusher
extends IteratingCallback {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final Queue<WindowEntry> windows = new ArrayDeque<WindowEntry>();
    private final Deque<Entry> frames = new ArrayDeque<Entry>();
    private final Queue<Entry> entries = new ArrayDeque<Entry>();
    private final List<Entry> actives = new ArrayList<Entry>();
    private final HTTP2Session session;
    private final Queue<ByteBuffer> buffers = new LinkedList<ByteBuffer>();
    private Entry stalled;
    private Throwable terminated;

    public HTTP2Flusher(HTTP2Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void window(StreamSPI stream, WindowUpdateFrame frame) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.windows.offer(new WindowEntry(stream, frame));
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepend(Entry entry) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.frames.offerFirst(entry);
                if (log.isDebugEnabled()) {
                    log.debug("Prepended {}, frames={}", (Object)entry, (Object)this.frames.size());
                }
            }
        }
        if (closed == null) {
            return true;
        }
        this.closed(entry, closed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Entry entry) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (closed == null) {
                this.frames.offer(entry);
                if (log.isDebugEnabled()) {
                    log.debug("Appended {}, frames={}", (Object)entry, (Object)this.frames.size());
                }
            }
        }
        if (closed == null) {
            return true;
        }
        this.closed(entry, closed);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.frames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IteratingCallback.Action process() throws Throwable {
        if (log.isDebugEnabled()) {
            log.debug("Flushing {}", (Object)this.session);
        }
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (this.terminated != null) {
                throw this.terminated;
            }
            while (!this.windows.isEmpty()) {
                WindowEntry entry = this.windows.poll();
                entry.perform();
            }
            if (!this.frames.isEmpty()) {
                for (Entry entry : this.frames) {
                    this.entries.offer(entry);
                    this.actives.add(entry);
                }
                this.frames.clear();
            }
        }
        if (this.entries.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("Flushed {}", (Object)this.session);
            }
            return IteratingCallback.Action.IDLE;
        }
        while (!this.entries.isEmpty()) {
            Entry entry = this.entries.poll();
            if (log.isDebugEnabled()) {
                log.debug("Processing {}", (Object)entry);
            }
            if (entry.reset()) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Resetting {}", (Object)entry);
                continue;
            }
            try {
                if (entry.generate(this.buffers)) {
                    if (entry.dataRemaining() <= 0) continue;
                    this.entries.offer(entry);
                    continue;
                }
                if (this.stalled != null) continue;
                this.stalled = entry;
            }
            catch (Throwable failure) {
                if (log.isDebugEnabled()) {
                    log.debug("Failure generating frame " + entry.frame, failure);
                }
                this.failed(failure);
                return IteratingCallback.Action.SUCCEEDED;
            }
        }
        if (this.buffers.isEmpty()) {
            this.complete();
            return IteratingCallback.Action.IDLE;
        }
        if (log.isDebugEnabled()) {
            log.debug("Writing {} buffers ({} bytes) for {} frames {}", new Object[]{this.buffers.size(), this.getBufferTotalLength(), this.actives.size(), this.actives.toString()});
        }
        ByteBufferArrayOutputEntry outputEntry = new ByteBufferArrayOutputEntry((Callback)this, this.buffers.toArray(BufferUtils.EMPTY_BYTE_BUFFER_ARRAY));
        this.session.getEndPoint().encode((Object)outputEntry);
        return IteratingCallback.Action.SCHEDULED;
    }

    private int getBufferTotalLength() {
        int length = 0;
        for (ByteBuffer buf : this.buffers) {
            length += buf.remaining();
        }
        return length;
    }

    public void succeeded() {
        if (log.isDebugEnabled()) {
            log.debug("Written {} frames for {}", (Object)this.actives.size(), this.actives);
        }
        this.complete();
        super.succeeded();
    }

    private void complete() {
        this.buffers.clear();
        this.actives.forEach(rec$ -> ((Entry)((Object)((Object)rec$))).complete());
        if (this.stalled != null) {
            Entry entry;
            int index;
            int i;
            for (i = index = this.actives.indexOf((Object)this.stalled); i < this.actives.size(); ++i) {
                entry = this.actives.get(i);
                if (entry.dataRemaining() <= 0) continue;
                this.append(entry);
            }
            for (i = 0; i < index; ++i) {
                entry = this.actives.get(i);
                if (entry.dataRemaining() <= 0) continue;
                this.append(entry);
            }
            this.stalled = null;
        }
        this.actives.clear();
    }

    protected void onCompleteSuccess() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompleteFailure(Throwable x) {
        Throwable closed;
        this.buffers.clear();
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = x;
            if (log.isDebugEnabled()) {
                log.debug("{}, active/queued={}/{}", new Object[]{closed != null ? "Closing" : "Failing", this.actives.size(), this.frames.size()});
            }
            this.actives.addAll(this.frames);
            this.frames.clear();
        }
        this.actives.forEach(entry -> entry.failed(x));
        this.actives.clear();
        if (closed == null) {
            this.session.abort(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate(Throwable cause) {
        Throwable closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = cause;
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)(closed != null ? "Terminated" : "Terminating"));
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    private void closed(Entry entry, Throwable failure) {
        entry.failed(failure);
    }

    private class WindowEntry {
        private final StreamSPI stream;
        private final WindowUpdateFrame frame;

        public WindowEntry(StreamSPI stream, WindowUpdateFrame frame) {
            this.stream = stream;
            this.frame = frame;
        }

        public void perform() {
            FlowControlStrategy flowControl = HTTP2Flusher.this.session.getFlowControlStrategy();
            flowControl.onWindowUpdate(HTTP2Flusher.this.session, this.stream, this.frame);
        }
    }

    public static abstract class Entry
    extends Callback.Nested {
        protected final Frame frame;
        protected final StreamSPI stream;
        private boolean reset;

        protected Entry(Frame frame, StreamSPI stream, Callback callback) {
            super(callback);
            this.frame = frame;
            this.stream = stream;
        }

        public int dataRemaining() {
            return 0;
        }

        protected abstract boolean generate(Queue<ByteBuffer> var1);

        private void complete() {
            if (this.reset) {
                this.failed((Throwable)new EofException("reset"));
            } else {
                this.succeeded();
            }
        }

        public void failed(Throwable x) {
            if (this.stream != null) {
                this.stream.close();
                this.stream.getSession().removeStream(this.stream);
            }
            super.failed(x);
        }

        private boolean reset() {
            this.reset = this.stream != null && this.stream.isReset() && !this.isProtocol();
            return this.reset;
        }

        private boolean isProtocol() {
            switch (this.frame.getType()) {
                case PRIORITY: 
                case RST_STREAM: 
                case GO_AWAY: 
                case WINDOW_UPDATE: 
                case DISCONNECT: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

