/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.stream.AbstractFlowControlStrategy;
import com.firefly.codec.http2.stream.SessionSPI;
import com.firefly.codec.http2.stream.StreamSPI;
import com.firefly.utils.concurrent.Atomics;
import com.firefly.utils.concurrent.Callback;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class BufferingFlowControlStrategy
extends AbstractFlowControlStrategy {
    private final AtomicInteger maxSessionRecvWindow = new AtomicInteger(65535);
    private final AtomicInteger sessionLevel = new AtomicInteger();
    private final Map<StreamSPI, AtomicInteger> streamLevels = new ConcurrentHashMap<StreamSPI, AtomicInteger>();
    private float bufferRatio;

    public BufferingFlowControlStrategy(float bufferRatio) {
        this(65535, bufferRatio);
    }

    public BufferingFlowControlStrategy(int initialStreamSendWindow, float bufferRatio) {
        super(initialStreamSendWindow);
        this.bufferRatio = bufferRatio;
    }

    public float getBufferRatio() {
        return this.bufferRatio;
    }

    public void setBufferRatio(float bufferRatio) {
        this.bufferRatio = bufferRatio;
    }

    @Override
    public void onStreamCreated(StreamSPI stream) {
        super.onStreamCreated(stream);
        this.streamLevels.put(stream, new AtomicInteger());
    }

    @Override
    public void onStreamDestroyed(StreamSPI stream) {
        this.streamLevels.remove(stream);
        super.onStreamDestroyed(stream);
    }

    @Override
    public void onDataConsumed(SessionSPI session, StreamSPI stream, int length) {
        int maxLevel;
        if (length <= 0) {
            return;
        }
        float ratio = this.bufferRatio;
        WindowUpdateFrame windowFrame = null;
        int level = this.sessionLevel.addAndGet(length);
        if (level > (maxLevel = (int)((float)this.maxSessionRecvWindow.get() * ratio))) {
            if (this.sessionLevel.compareAndSet(level, 0)) {
                session.updateRecvWindow(level);
                if (log.isDebugEnabled()) {
                    log.debug("Data consumed, {} bytes, updated session recv window by {}/{} for {}", new Object[]{length, level, maxLevel, session});
                }
                windowFrame = new WindowUpdateFrame(0, level);
            } else if (log.isDebugEnabled()) {
                log.debug("Data consumed, {} bytes, concurrent session recv window level {}/{} for {}", new Object[]{length, this.sessionLevel, maxLevel, session});
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Data consumed, {} bytes, session recv window level {}/{} for {}", new Object[]{length, level, maxLevel, session});
        }
        Frame[] windowFrames = Frame.EMPTY_ARRAY;
        if (stream != null) {
            if (stream.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug("Data consumed, {} bytes, ignoring update stream recv window for closed {}", (Object)length, (Object)stream);
                }
            } else {
                AtomicInteger streamLevel = this.streamLevels.get(stream);
                if (streamLevel != null) {
                    level = streamLevel.addAndGet(length);
                    if (level > (maxLevel = (int)((float)this.getInitialStreamRecvWindow() * ratio))) {
                        level = streamLevel.getAndSet(0);
                        stream.updateRecvWindow(level);
                        if (log.isDebugEnabled()) {
                            log.debug("Data consumed, {} bytes, updated stream recv window by {}/{} for {}", new Object[]{length, level, maxLevel, stream});
                        }
                        WindowUpdateFrame frame = new WindowUpdateFrame(stream.getId(), level);
                        if (windowFrame == null) {
                            windowFrame = frame;
                        } else {
                            windowFrames = new Frame[]{frame};
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug("Data consumed, {} bytes, stream recv window level {}/{} for {}", new Object[]{length, level, maxLevel, stream});
                    }
                }
            }
        }
        if (windowFrame != null) {
            session.frames(stream, Callback.NOOP, windowFrame, windowFrames);
        }
    }

    @Override
    public void windowUpdate(SessionSPI session, StreamSPI stream, WindowUpdateFrame frame) {
        super.windowUpdate(session, stream, frame);
        if (frame.getStreamId() == 0) {
            int sessionWindow = session.updateRecvWindow(0);
            Atomics.updateMax((AtomicInteger)this.maxSessionRecvWindow, (int)sessionWindow);
        }
    }

    public String toString() {
        return String.format("%s@%x[ratio=%.2f,sessionLevel=%s,sessionStallTime=%dms,streamsStallTime=%dms]", this.getClass().getSimpleName(), this.hashCode(), Float.valueOf(this.bufferRatio), this.sessionLevel, this.getSessionStallTime(), this.getStreamsStallTime());
    }
}

