/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.stream.HTTPOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedHTTPOutputStream
extends OutputStream {
    private int bufferSize;
    private HTTPOutputStream output;
    private byte[] buf;
    private int count;

    public BufferedHTTPOutputStream(HTTPOutputStream output, int bufferSize) {
        this.bufferSize = bufferSize;
        this.output = output;
        this.buf = bufferSize > 1024 ? new byte[bufferSize] : new byte[1024];
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flush();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public synchronized void write(byte[] array, int offset, int length) throws IOException {
        if (array == null || array.length == 0 || length <= 0) {
            return;
        }
        if (offset < 0) {
            throw new IllegalArgumentException("the offset is less than 0");
        }
        if (length >= this.buf.length) {
            this.flush();
            this.output.write(array, offset, length);
            return;
        }
        if (length > this.buf.length - this.count) {
            this.flush();
        }
        System.arraycopy(array, offset, this.buf, this.count, length);
        this.count += length;
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.count > 0) {
            this.output.write(this.buf, 0, this.count);
            this.count = 0;
            this.buf = new byte[this.bufferSize];
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.flush();
        this.output.close();
    }
}

