/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.stream.AbstractHTTPConnection;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.net.Handler;
import com.firefly.net.Session;
import com.firefly.server.utils.StatisticsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTPHandler
implements Handler {
    protected static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected final HTTP2Configuration config;

    public AbstractHTTPHandler(HTTP2Configuration config) {
        this.config = config;
    }

    public void messageReceived(Session session, Object message) throws Throwable {
    }

    public void exceptionCaught(Session session, Throwable t) throws Throwable {
        AbstractHTTPConnection httpConnection;
        log.error("HTTP handler exception", t);
        if (session.getAttachment() instanceof AbstractHTTPConnection && (httpConnection = (AbstractHTTPConnection)session.getAttachment()) != null) {
            if (httpConnection.getExceptionListener() != null) {
                try {
                    httpConnection.getExceptionListener().call((Object)httpConnection, (Object)t);
                }
                catch (Throwable t1) {
                    log.error("http connection exception listener error", t1);
                }
            }
            if (httpConnection.isOpen()) {
                httpConnection.close();
            }
        }
    }

    public void sessionClosed(Session session) throws Throwable {
        block6: {
            log.info("session {} closed", (Object)session.getSessionId());
            StatisticsUtils.saveConnectionInfo(session);
            try {
                AbstractHTTPConnection httpConnection;
                if (!(session.getAttachment() instanceof AbstractHTTPConnection) || (httpConnection = (AbstractHTTPConnection)session.getAttachment()) == null) break block6;
                if (httpConnection.getClosedListener() != null) {
                    try {
                        httpConnection.getClosedListener().call((Object)httpConnection);
                    }
                    catch (Throwable t1) {
                        log.error("http connection closed listener error", t1);
                    }
                }
                if (httpConnection.isOpen()) {
                    httpConnection.close();
                }
            }
            catch (Throwable t) {
                log.error("http2 conection close exception", t);
            }
        }
    }
}

