/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.stream.HTTPConnection;
import com.firefly.net.Session;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.function.Action1;
import com.firefly.utils.function.Action2;
import java.io.IOException;
import java.net.InetSocketAddress;

public abstract class AbstractHTTPConnection
implements HTTPConnection {
    protected final SSLSession sslSession;
    protected final Session tcpSession;
    protected final HttpVersion httpVersion;
    protected volatile Object attachment;
    protected Action1<HTTPConnection> closedListener;
    protected Action2<HTTPConnection, Throwable> exceptionListener;

    public AbstractHTTPConnection(SSLSession sslSession, Session tcpSession, HttpVersion httpVersion) {
        this.sslSession = sslSession;
        this.tcpSession = tcpSession;
        this.httpVersion = httpVersion;
    }

    @Override
    public Object getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    @Override
    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public boolean isOpen() {
        return this.tcpSession.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.sslSession != null && this.sslSession.isOpen()) {
            this.sslSession.close();
        }
        if (this.tcpSession != null && this.tcpSession.isOpen()) {
            this.tcpSession.close();
        }
        this.attachment = null;
    }

    @Override
    public boolean isEncrypted() {
        return this.sslSession != null;
    }

    @Override
    public int getSessionId() {
        return this.tcpSession.getSessionId();
    }

    @Override
    public long getReadBytes() {
        return this.tcpSession.getReadBytes();
    }

    @Override
    public long getWrittenBytes() {
        return this.tcpSession.getWrittenBytes();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.tcpSession.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.tcpSession.getRemoteAddress();
    }

    @Override
    public HTTPConnection closedListener(Action1<HTTPConnection> closedListener) {
        this.closedListener = closedListener;
        return this;
    }

    @Override
    public HTTPConnection exceptionListener(Action2<HTTPConnection, Throwable> exceptionListener) {
        this.exceptionListener = exceptionListener;
        return this;
    }

    Action1<HTTPConnection> getClosedListener() {
        return this.closedListener;
    }

    Action2<HTTPConnection, Throwable> getExceptionListener() {
        return this.exceptionListener;
    }
}

