/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.DisconnectFrame;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.utils.concurrent.Callback;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHTTP2OutputStream
extends HTTPOutputStream {
    protected static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    protected boolean isChunked;
    private long size;
    private long contentLength;
    private boolean isWriting;
    private LinkedList<Frame> frames = new LinkedList();
    private FrameCallback frameCallback = new FrameCallback();
    private DataFrame currentDataFrame;

    public AbstractHTTP2OutputStream(MetaData info, boolean clientMode) {
        super(info, clientMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeWithContentLength(ByteBuffer[] data) throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (!this.commited) {
                long contentLength = 0L;
                for (ByteBuffer buf : data) {
                    contentLength += (long)buf.remaining();
                }
                this.info.getFields().put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
            }
            for (ByteBuffer buf : data) {
                this.write(buf);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public synchronized void writeWithContentLength(ByteBuffer data) throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (!this.commited) {
                this.info.getFields().put(HttpHeader.CONTENT_LENGTH, String.valueOf(data.remaining()));
            }
            this.write(data);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void commit() throws IOException {
        this.commit(false);
    }

    @Override
    public void write(ByteBuffer data) throws IOException {
        if (this.closed) {
            return;
        }
        if (data == null || !data.hasRemaining()) {
            return;
        }
        if (!this.commited) {
            this.commit(false);
        }
        boolean endStream = false;
        if (!this.isChunked) {
            this.size += (long)data.remaining();
            log.debug("http2 output size: {}, content length: {}", (Object)this.size, (Object)this.contentLength);
            if (this.size >= this.contentLength) {
                endStream = true;
            }
        }
        Stream stream = this.getStream();
        DataFrame frame = new DataFrame(stream.getId(), data, endStream);
        this.writeFrame(frame);
    }

    public synchronized void writeFrame(Frame frame) {
        switch (frame.getType()) {
            case DATA: {
                if (!this.commited) {
                    throw new IllegalStateException("the output stream is not commited");
                }
                DataFrame dataFrame = (DataFrame)frame;
                if (this.isChunked) {
                    if (dataFrame.isEndStream()) {
                        if (this.currentDataFrame == null) {
                            this.writeDataFrame(dataFrame);
                            break;
                        }
                        this.writeDataFrame(this.currentDataFrame);
                        this.writeDataFrame(dataFrame);
                        break;
                    }
                    if (this.currentDataFrame == null) {
                        this.currentDataFrame = dataFrame;
                        break;
                    }
                    this.writeDataFrame(this.currentDataFrame);
                    this.currentDataFrame = dataFrame;
                    break;
                }
                this.writeDataFrame(dataFrame);
                break;
            }
            case HEADERS: {
                this.writeHeadersFrame((HeadersFrame)frame);
                break;
            }
            case DISCONNECT: {
                if (this.isChunked) {
                    if (this.currentDataFrame != null) {
                        if (!this.currentDataFrame.isEndStream()) {
                            DataFrame theLastDataFrame = new DataFrame(this.currentDataFrame.getStreamId(), this.currentDataFrame.getData(), true);
                            this.writeDataFrame(theLastDataFrame);
                            this.currentDataFrame = null;
                            break;
                        }
                        throw new IllegalStateException("the end data stream is cached");
                    }
                    throw new IllegalStateException("the cached data stream is null");
                }
                throw new IllegalArgumentException("the frame type is error, only the chunked encoding can accept disconnect frame, current frame type is " + (Object)((Object)frame.getType()));
            }
            default: {
                throw new IllegalArgumentException("the frame type is error, the type is " + (Object)((Object)frame.getType()));
            }
        }
    }

    protected synchronized void writeDataFrame(DataFrame dataFrame) {
        this.closed = dataFrame.isEndStream();
        if (this.isWriting) {
            this.frames.offer(dataFrame);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("the stream {} writes a frame {}, remaining frames are {}", new Object[]{dataFrame.getStreamId(), dataFrame, this.frames.toString()});
            }
            this.isWriting = true;
            this.getStream().data(dataFrame, this.frameCallback);
        }
    }

    protected synchronized void writeHeadersFrame(HeadersFrame headersFrame) {
        this.closed = headersFrame.isEndStream();
        if (this.isWriting) {
            this.frames.offer(headersFrame);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("the stream {} writes a frame {}", (Object)headersFrame.getStreamId(), (Object)headersFrame);
            }
            this.isWriting = true;
            this.getStream().headers(headersFrame, this.frameCallback);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        log.debug("http2 output stream is closing");
        if (!this.commited) {
            this.commit(true);
        } else if (this.isChunked) {
            log.debug("output the last data frame to end stream");
            this.writeFrame(new DisconnectFrame());
        } else {
            this.closed = true;
        }
    }

    protected synchronized void commit(boolean endStream) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.commited) {
            return;
        }
        this.contentLength = this.info.getFields().getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (endStream) {
            if (log.isDebugEnabled()) {
                log.debug("stream {} commits header and closes it", (Object)this.getStream().getId());
            }
            this.isChunked = false;
        } else {
            boolean bl = this.isChunked = this.contentLength <= 0L;
        }
        if (log.isDebugEnabled()) {
            log.debug("is stream {} using chunked encoding ? {}", (Object)this.getStream().getId(), (Object)this.isChunked);
        }
        this.info.getFields().put(HttpHeader.X_POWERED_BY, "Firefly 4.0");
        this.info.getFields().put(HttpHeader.SERVER, "Firefly 4.0");
        Stream stream = this.getStream();
        HeadersFrame headersFrame = new HeadersFrame(stream.getId(), this.info, null, endStream);
        if (log.isDebugEnabled()) {
            log.debug("stream {} commits the header frame {}", (Object)stream.getId(), (Object)headersFrame);
        }
        this.commited = true;
        this.writeFrame(headersFrame);
    }

    protected abstract Stream getStream();

    private class FrameCallback
    implements Callback {
        private FrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            AbstractHTTP2OutputStream abstractHTTP2OutputStream = AbstractHTTP2OutputStream.this;
            synchronized (abstractHTTP2OutputStream) {
                block9: {
                    block8: {
                        AbstractHTTP2OutputStream.this.isWriting = false;
                        Frame frame = (Frame)AbstractHTTP2OutputStream.this.frames.poll();
                        if (frame == null) break block8;
                        switch (frame.getType()) {
                            case DATA: {
                                AbstractHTTP2OutputStream.this.writeDataFrame((DataFrame)frame);
                                break block9;
                            }
                            case HEADERS: {
                                AbstractHTTP2OutputStream.this.writeHeadersFrame((HeadersFrame)frame);
                                break block9;
                            }
                            default: {
                                throw new IllegalArgumentException("the frame type is error, the type is " + (Object)((Object)frame.getType()));
                            }
                        }
                    }
                    AbstractHTTP2OutputStream.this.isWriting = false;
                }
                if (log.isDebugEnabled()) {
                    log.debug("the stream {} outputs http2 frame successfully, and the queue size is {}", (Object)AbstractHTTP2OutputStream.this.getStream().getId(), (Object)AbstractHTTP2OutputStream.this.frames.size());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable x) {
            AbstractHTTP2OutputStream abstractHTTP2OutputStream = AbstractHTTP2OutputStream.this;
            synchronized (abstractHTTP2OutputStream) {
                log.error("the stream {} outputs http2 frame unsuccessfully ", (Object)x, (Object)AbstractHTTP2OutputStream.this.getStream().getId());
                AbstractHTTP2OutputStream.this.isWriting = false;
            }
        }
    }
}

