/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.decode.Parser;
import com.firefly.codec.http2.encode.Generator;
import com.firefly.codec.http2.model.HttpVersion;
import com.firefly.codec.http2.stream.AbstractFlowControlStrategy;
import com.firefly.codec.http2.stream.AbstractHTTPConnection;
import com.firefly.codec.http2.stream.BufferingFlowControlStrategy;
import com.firefly.codec.http2.stream.ConnectionType;
import com.firefly.codec.http2.stream.FlowControlStrategy;
import com.firefly.codec.http2.stream.HTTP2Configuration;
import com.firefly.codec.http2.stream.HTTP2Session;
import com.firefly.codec.http2.stream.Session;
import com.firefly.codec.http2.stream.SimpleFlowControlStrategy;
import com.firefly.net.tcp.ssl.SSLSession;
import com.firefly.utils.concurrent.Scheduler;
import com.firefly.utils.concurrent.Schedulers;

public abstract class AbstractHTTP2Connection
extends AbstractHTTPConnection {
    protected final HTTP2Session http2Session;
    protected final Parser parser;
    protected final Generator generator;
    protected static final Scheduler scheduler = Schedulers.createScheduler();

    public static void stopScheduler() {
        scheduler.stop();
    }

    public AbstractHTTP2Connection(HTTP2Configuration config, com.firefly.net.Session tcpSession, SSLSession sslSession, Session.Listener listener) {
        super(sslSession, tcpSession, HttpVersion.HTTP_2);
        AbstractFlowControlStrategy flowControl;
        switch (config.getFlowControlStrategy()) {
            case "buffer": {
                flowControl = new BufferingFlowControlStrategy(config.getInitialStreamSendWindow(), 0.5f);
                break;
            }
            case "simple": {
                flowControl = new SimpleFlowControlStrategy(config.getInitialStreamSendWindow());
                break;
            }
            default: {
                flowControl = new SimpleFlowControlStrategy(config.getInitialStreamSendWindow());
            }
        }
        this.generator = new Generator(config.getMaxDynamicTableSize(), config.getMaxHeaderBlockFragment());
        this.http2Session = this.initHTTP2Session(config, flowControl, listener);
        this.parser = this.initParser(config);
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.HTTP2;
    }

    protected abstract HTTP2Session initHTTP2Session(HTTP2Configuration var1, FlowControlStrategy var2, Session.Listener var3);

    protected abstract Parser initParser(HTTP2Configuration var1);

    public Session getHttp2Session() {
        return this.http2Session;
    }
}

