/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.encode.HttpGenerator;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.codec.http2.stream.HTTPOutputStream;
import com.firefly.net.Session;
import com.firefly.utils.io.BufferUtils;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractHTTP1OutputStream
extends HTTPOutputStream {
    public AbstractHTTP1OutputStream(MetaData info, boolean clientMode) {
        super(info, clientMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeWithContentLength(ByteBuffer[] data) throws IOException {
        try {
            long contentLength = 0L;
            for (ByteBuffer buf : data) {
                contentLength += (long)buf.remaining();
            }
            this.info.getFields().put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
            for (ByteBuffer buf : data) {
                this.write(buf);
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public synchronized void writeWithContentLength(ByteBuffer data) throws IOException {
        try {
            this.info.getFields().put(HttpHeader.CONTENT_LENGTH, String.valueOf(data.remaining()));
            this.write(data);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void commit() throws IOException {
        this.commit(null);
    }

    protected synchronized void commit(ByteBuffer data) throws IOException {
        if (this.closed) {
            return;
        }
        if (this.commited) {
            return;
        }
        HttpGenerator generator = this.getHttpGenerator();
        Session tcpSession = this.getSession();
        ByteBuffer header = this.getHeaderByteBuffer();
        HttpGenerator.Result generatorResult = this.generate(this.info, header, null, data, false);
        if (generatorResult == HttpGenerator.Result.FLUSH && generator.getState() == HttpGenerator.State.COMMITTED) {
            tcpSession.encode((Object)header);
            if (data != null) {
                tcpSession.encode((Object)data);
            }
            this.commited = true;
        } else {
            this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
        }
    }

    @Override
    public synchronized void write(ByteBuffer data) throws IOException {
        if (this.closed) {
            return;
        }
        if (!data.hasRemaining()) {
            return;
        }
        HttpGenerator generator = this.getHttpGenerator();
        Session tcpSession = this.getSession();
        if (!this.commited) {
            this.commit(data);
        } else if (generator.isChunking()) {
            ByteBuffer chunk = BufferUtils.allocate((int)12);
            HttpGenerator.Result generatorResult = this.generate(null, null, chunk, data, false);
            if (generatorResult == HttpGenerator.Result.FLUSH && generator.getState() == HttpGenerator.State.COMMITTED) {
                tcpSession.encode((Object)chunk);
                tcpSession.encode((Object)data);
            } else {
                this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
            }
        } else {
            HttpGenerator.Result generatorResult = this.generate(null, null, null, data, false);
            if (generatorResult == HttpGenerator.Result.FLUSH && generator.getState() == HttpGenerator.State.COMMITTED) {
                tcpSession.encode((Object)data);
            } else {
                this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            log.debug("http1 output stream is closing");
            HttpGenerator generator = this.getHttpGenerator();
            Session tcpSession = this.getSession();
            if (!this.commited) {
                ByteBuffer header = this.getHeaderByteBuffer();
                HttpGenerator.Result generatorResult = this.generate(this.info, header, null, null, true);
                if (generatorResult == HttpGenerator.Result.FLUSH && generator.getState() == HttpGenerator.State.COMPLETING) {
                    tcpSession.encode((Object)header);
                    this.generateLastData(generator);
                } else {
                    this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
                }
                this.commited = true;
            } else if (generator.isChunking()) {
                log.debug("http1 output stream is generating chunk");
                ByteBuffer chunk = BufferUtils.allocate((int)12);
                HttpGenerator.Result generatorResult = this.generate(null, null, chunk, null, true);
                if (generatorResult == HttpGenerator.Result.CONTINUE && generator.getState() == HttpGenerator.State.COMPLETING) {
                    generatorResult = this.generate(null, null, chunk, null, true);
                    if (generatorResult == HttpGenerator.Result.FLUSH && generator.getState() == HttpGenerator.State.COMPLETING) {
                        tcpSession.encode((Object)chunk);
                        this.generateLastData(generator);
                    } else {
                        this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
                    }
                } else {
                    this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
                }
            } else {
                HttpGenerator.Result generatorResult = this.generate(null, null, null, null, true);
                if (generatorResult == HttpGenerator.Result.CONTINUE && generator.getState() == HttpGenerator.State.COMPLETING) {
                    this.generateLastData(generator);
                } else {
                    this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
                }
            }
        }
        finally {
            this.closed = true;
        }
    }

    private void generateLastData(HttpGenerator generator) throws IOException {
        HttpGenerator.Result generatorResult = this.generate(null, null, null, null, true);
        if (generator.getState() == HttpGenerator.State.END) {
            if (generatorResult == HttpGenerator.Result.DONE) {
                this.generateHTTPMessageSuccessfully();
            } else if (generatorResult == HttpGenerator.Result.SHUTDOWN_OUT) {
                this.getSession().close();
            } else {
                this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
            }
        } else {
            this.generateHTTPMessageExceptionally(generatorResult, generator.getState());
        }
    }

    protected HttpGenerator.Result generate(MetaData info, ByteBuffer header, ByteBuffer chunk, ByteBuffer content, boolean last) throws IOException {
        HttpGenerator generator = this.getHttpGenerator();
        if (this.clientMode) {
            return generator.generateRequest((MetaData.Request)info, header, chunk, content, last);
        }
        return generator.generateResponse((MetaData.Response)info, false, header, chunk, content, last);
    }

    protected abstract ByteBuffer getHeaderByteBuffer();

    protected abstract Session getSession();

    protected abstract HttpGenerator getHttpGenerator();

    protected abstract void generateHTTPMessageSuccessfully();

    protected abstract void generateHTTPMessageExceptionally(HttpGenerator.Result var1, HttpGenerator.State var2);
}

