/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.stream;

import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.stream.FlowControlStrategy;
import com.firefly.codec.http2.stream.SessionSPI;
import com.firefly.codec.http2.stream.Stream;
import com.firefly.codec.http2.stream.StreamSPI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlowControlStrategy
implements FlowControlStrategy {
    protected static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final AtomicLong sessionStall = new AtomicLong();
    private final AtomicLong sessionStallTime = new AtomicLong();
    private final Map<StreamSPI, Long> streamsStalls = new ConcurrentHashMap<StreamSPI, Long>();
    private final AtomicLong streamsStallTime = new AtomicLong();
    private int initialStreamSendWindow;
    private int initialStreamRecvWindow;

    public AbstractFlowControlStrategy(int initialStreamSendWindow) {
        this.initialStreamSendWindow = initialStreamSendWindow;
        this.initialStreamRecvWindow = 65535;
    }

    public int getInitialStreamSendWindow() {
        return this.initialStreamSendWindow;
    }

    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    @Override
    public void onStreamCreated(StreamSPI stream) {
        stream.updateSendWindow(this.initialStreamSendWindow);
        stream.updateRecvWindow(this.initialStreamRecvWindow);
    }

    @Override
    public void onStreamDestroyed(StreamSPI stream) {
    }

    @Override
    public void updateInitialStreamWindow(SessionSPI session, int initialStreamWindow, boolean local) {
        int previousInitialStreamWindow;
        if (local) {
            previousInitialStreamWindow = this.getInitialStreamRecvWindow();
            this.initialStreamRecvWindow = initialStreamWindow;
        } else {
            previousInitialStreamWindow = this.getInitialStreamSendWindow();
            this.initialStreamSendWindow = initialStreamWindow;
        }
        int delta = initialStreamWindow - previousInitialStreamWindow;
        for (Stream stream : session.getStreams()) {
            if (local) {
                ((StreamSPI)stream).updateRecvWindow(delta);
                if (!log.isDebugEnabled()) continue;
                log.debug("Updated initial stream recv window {} -> {} for {}", new Object[]{previousInitialStreamWindow, initialStreamWindow, stream});
                continue;
            }
            session.onWindowUpdate((StreamSPI)stream, new WindowUpdateFrame(stream.getId(), delta));
        }
    }

    @Override
    public void onWindowUpdate(SessionSPI session, StreamSPI stream, WindowUpdateFrame frame) {
        int delta = frame.getWindowDelta();
        if (frame.getStreamId() > 0) {
            if (stream != null) {
                int oldSize = stream.updateSendWindow(delta);
                if (log.isDebugEnabled()) {
                    log.debug("Updated stream send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, stream});
                }
                if (oldSize <= 0) {
                    this.onStreamUnstalled(stream);
                }
            }
        } else {
            int oldSize = session.updateSendWindow(delta);
            if (log.isDebugEnabled()) {
                log.debug("Updated session send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, session});
            }
            if (oldSize <= 0) {
                this.onSessionUnstalled(session);
            }
        }
    }

    @Override
    public void onDataReceived(SessionSPI session, StreamSPI stream, int length) {
        int oldSize = session.updateRecvWindow(-length);
        if (log.isDebugEnabled()) {
            log.debug("Data received, {} bytes, updated session recv window {} -> {} for {}", new Object[]{length, oldSize, oldSize - length, session});
        }
        if (stream != null) {
            oldSize = stream.updateRecvWindow(-length);
            if (log.isDebugEnabled()) {
                log.debug("Data received, {} bytes, updated stream recv window {} -> {} for {}", new Object[]{length, oldSize, oldSize - length, stream});
            }
        }
    }

    @Override
    public void windowUpdate(SessionSPI session, StreamSPI stream, WindowUpdateFrame frame) {
    }

    @Override
    public void onDataSending(StreamSPI stream, int length) {
        if (length == 0) {
            return;
        }
        SessionSPI session = stream.getSession();
        int oldSessionWindow = session.updateSendWindow(-length);
        int newSessionWindow = oldSessionWindow - length;
        if (log.isDebugEnabled()) {
            log.debug("Sending, session send window {} -> {} for {}", new Object[]{oldSessionWindow, newSessionWindow, session});
        }
        if (newSessionWindow <= 0) {
            this.onSessionStalled(session);
        }
        int oldStreamWindow = stream.updateSendWindow(-length);
        int newStreamWindow = oldStreamWindow - length;
        if (log.isDebugEnabled()) {
            log.debug("Sending, stream send window {} -> {} for {}", new Object[]{oldStreamWindow, newStreamWindow, stream});
        }
        if (newStreamWindow <= 0) {
            this.onStreamStalled(stream);
        }
    }

    @Override
    public void onDataSent(StreamSPI stream, int length) {
    }

    protected void onSessionStalled(SessionSPI session) {
        this.sessionStall.set(System.nanoTime());
        if (log.isDebugEnabled()) {
            log.debug("Session stalled {}", (Object)session);
        }
    }

    protected void onStreamStalled(StreamSPI stream) {
        this.streamsStalls.put(stream, System.nanoTime());
        if (log.isDebugEnabled()) {
            log.debug("Stream stalled {}", (Object)stream);
        }
    }

    protected void onSessionUnstalled(SessionSPI session) {
        this.sessionStallTime.addAndGet(System.nanoTime() - this.sessionStall.getAndSet(0L));
        if (log.isDebugEnabled()) {
            log.debug("Session unstalled {}", (Object)session);
        }
    }

    protected void onStreamUnstalled(StreamSPI stream) {
        Long time = this.streamsStalls.remove(stream);
        if (time != null) {
            this.streamsStallTime.addAndGet(System.nanoTime() - time);
        }
        if (log.isDebugEnabled()) {
            log.debug("Stream unstalled {}", (Object)stream);
        }
    }

    public long getSessionStallTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.sessionStallTime.get());
    }

    public long getStreamsStallTime() {
        return TimeUnit.NANOSECONDS.toMillis(this.streamsStallTime.get());
    }

    public void reset() {
        this.sessionStallTime.set(0L);
        this.streamsStallTime.set(0L);
    }
}

