/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.model;

import com.firefly.codec.http2.model.QuotedCSV;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class QuotedQualityCSV
extends QuotedCSV
implements Iterable<String> {
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);
    private final List<Double> _quality = new ArrayList<Double>();
    private boolean _sorted = false;
    private final Function<String, Integer> secondaryOrderingFunction;

    public QuotedQualityCSV() {
        this(s -> s.length());
    }

    public QuotedQualityCSV(String[] serverPreferredValueOrder) {
        this(s -> {
            for (int i = 0; i < serverPreferredValueOrder.length; ++i) {
                if (!serverPreferredValueOrder[i].equals(s)) continue;
                return serverPreferredValueOrder.length - i;
            }
            if ("*".equals(s)) {
                return serverPreferredValueOrder.length;
            }
            return Integer.MIN_VALUE;
        });
    }

    public QuotedQualityCSV(Function<String, Integer> secondaryOrderingFunction) {
        super(new String[0]);
        this.secondaryOrderingFunction = secondaryOrderingFunction;
    }

    @Override
    public void addValue(String value) {
        super.addValue(value);
        while (this._quality.size() < this._values.size()) {
            this._quality.add(ONE);
        }
    }

    @Override
    protected void parsedValue(StringBuffer buffer) {
        super.parsedValue(buffer);
    }

    @Override
    protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
        if (buffer.charAt(paramName) == 'q' && paramValue > paramName && buffer.charAt(paramName + 1) == '=') {
            Double q;
            try {
                q = this._keepQuotes && buffer.charAt(paramValue) == '\"' ? new Double(buffer.substring(paramValue + 1, buffer.length() - 1)) : new Double(buffer.substring(paramValue));
            }
            catch (Exception e) {
                q = ZERO;
            }
            buffer.setLength(paramName - 1);
            while (this._quality.size() < this._values.size()) {
                this._quality.add(ONE);
            }
            this._quality.add(q);
        }
    }

    @Override
    public List<String> getValues() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values;
    }

    @Override
    public Iterator<String> iterator() {
        if (!this._sorted) {
            this.sort();
        }
        return this._values.iterator();
    }

    protected void sort() {
        this._sorted = true;
        Double last = ZERO;
        int lastOrderIndex = Integer.MIN_VALUE;
        int i = this._values.size();
        while (i-- > 0) {
            String v = (String)this._values.get(i);
            Double q = this._quality.get(i);
            int compare = last.compareTo(q);
            if (compare > 0 || compare == 0 && this.secondaryOrderingFunction.apply(v) < lastOrderIndex) {
                this._values.set(i, this._values.get(i + 1));
                this._values.set(i + 1, v);
                this._quality.set(i, this._quality.get(i + 1));
                this._quality.set(i + 1, q);
                last = ZERO;
                lastOrderIndex = 0;
                i = this._values.size();
                continue;
            }
            last = q;
            lastOrderIndex = this.secondaryOrderingFunction.apply(v);
        }
        int last_element = this._quality.size();
        while (last_element > 0 && this._quality.get(--last_element).equals(ZERO)) {
            this._quality.remove(last_element);
            this._values.remove(last_element);
        }
    }
}

