/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.model;

import com.firefly.codec.http2.encode.Http1FieldPreEncoder;
import com.firefly.codec.http2.encode.HttpFieldPreEncoder;
import com.firefly.codec.http2.hpack.HpackFieldPreEncoder;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.HttpVersion;
import java.nio.ByteBuffer;

public class PreEncodedHttpField
extends HttpField {
    private static final HttpFieldPreEncoder[] __encoders = new HttpFieldPreEncoder[]{new HpackFieldPreEncoder(), new Http1FieldPreEncoder()};
    private final byte[][] _encodedField = new byte[2][];

    public PreEncodedHttpField(HttpHeader header, String name, String value) {
        super(header, name, value);
        HttpFieldPreEncoder[] httpFieldPreEncoderArray = __encoders;
        int n = httpFieldPreEncoderArray.length;
        for (int i = 0; i < n; ++i) {
            HttpFieldPreEncoder e;
            this._encodedField[(e = httpFieldPreEncoderArray[i]).getHttpVersion() == HttpVersion.HTTP_2 ? 1 : 0] = e.getEncodedField(header, header.asString(), value);
        }
    }

    public PreEncodedHttpField(HttpHeader header, String value) {
        this(header, header.asString(), value);
    }

    public PreEncodedHttpField(String name, String value) {
        this(null, name, value);
    }

    public void putTo(ByteBuffer bufferInFillMode, HttpVersion version) {
        bufferInFillMode.put(this._encodedField[version == HttpVersion.HTTP_2 ? 1 : 0]);
    }
}

