/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.model;

import com.firefly.utils.collection.ArrayTrie;
import com.firefly.utils.collection.Trie;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https"),
    WS("ws"),
    WSS("wss");

    public static final Trie<HttpScheme> CACHE;
    private final String string;
    private final ByteBuffer buffer;

    private HttpScheme(String s) {
        this.string = s;
        this.buffer = BufferUtils.toBuffer((String)s);
    }

    public ByteBuffer asByteBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    public boolean is(String s) {
        return s != null && this.string.equalsIgnoreCase(s);
    }

    public String asString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    static {
        CACHE = new ArrayTrie();
        for (HttpScheme version : HttpScheme.values()) {
            CACHE.put(version.asString(), (Object)version);
        }
    }
}

