/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.model;

import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.utils.collection.ArrayTrie;
import com.firefly.utils.collection.Trie;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;

public enum HttpHeaderValue {
    CLOSE("close"),
    CHUNKED("chunked"),
    GZIP("gzip"),
    IDENTITY("identity"),
    KEEP_ALIVE("keep-alive"),
    CONTINUE("100-continue"),
    PROCESSING("102-processing"),
    TE("TE"),
    BYTES("bytes"),
    NO_CACHE("no-cache"),
    UPGRADE("Upgrade"),
    UNKNOWN("::UNKNOWN::");

    private static final EnumSet<HttpHeader> __known;
    public static final Trie<HttpHeaderValue> CACHE;
    private final String string;
    private final ByteBuffer buffer;

    private HttpHeaderValue(String s) {
        this.string = s;
        this.buffer = ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
    }

    public ByteBuffer toBuffer() {
        return this.buffer.asReadOnlyBuffer();
    }

    public boolean is(String s) {
        return this.string.equalsIgnoreCase(s);
    }

    public String asString() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public static boolean hasKnownValues(HttpHeader header) {
        if (header == null) {
            return false;
        }
        return __known.contains((Object)header);
    }

    static {
        __known = EnumSet.of(HttpHeader.CONNECTION, HttpHeader.TRANSFER_ENCODING, HttpHeader.CONTENT_ENCODING);
        CACHE = new ArrayTrie();
        for (HttpHeaderValue value : HttpHeaderValue.values()) {
            if (value == UNKNOWN) continue;
            CACHE.put(value.toString(), (Object)value);
        }
    }
}

