/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.model;

import com.firefly.codec.http2.model.Cookie;
import com.firefly.utils.StringUtils;
import com.firefly.utils.VerifyUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class CookieParser {
    public static void parseCookies(String cookieStr, CookieParserCallback callback) {
        String[] cookieKeyValues;
        if (VerifyUtils.isEmpty((String)cookieStr)) {
            throw new IllegalArgumentException("the cookie string is empty");
        }
        for (String cookieKeyValue : cookieKeyValues = StringUtils.split((String)cookieStr, (char)';')) {
            String[] kv = StringUtils.split((String)cookieKeyValue, (String)"=", (int)2);
            if (kv != null) {
                if (kv.length == 2) {
                    callback.cookie(kv[0].trim(), kv[1].trim());
                    continue;
                }
                if (kv.length == 1) {
                    callback.cookie(kv[0].trim(), "");
                    continue;
                }
                throw new IllegalStateException("the cookie string format error");
            }
            throw new IllegalStateException("the cookie string format error");
        }
    }

    public static Cookie parseSetCookie(String cookieStr) {
        final Cookie cookie = new Cookie();
        CookieParser.parseCookies(cookieStr, new CookieParserCallback(){

            @Override
            public void cookie(String name, String value) {
                if ("Comment".equalsIgnoreCase(name)) {
                    cookie.setComment(value);
                } else if ("Domain".equalsIgnoreCase(name)) {
                    cookie.setDomain(value);
                } else if ("Max-Age".equalsIgnoreCase(name)) {
                    cookie.setMaxAge(Integer.parseInt(value));
                } else if ("Path".equalsIgnoreCase(name)) {
                    cookie.setPath(value);
                } else if ("Secure".equalsIgnoreCase(name)) {
                    cookie.setSecure(true);
                } else if ("Version".equalsIgnoreCase(name)) {
                    cookie.setVersion(Integer.parseInt(value));
                } else {
                    cookie.setName(name);
                    cookie.setValue(value);
                }
            }
        });
        return cookie;
    }

    public static List<Cookie> parseCookie(String cookieStr) {
        final ArrayList<Cookie> list = new ArrayList<Cookie>();
        CookieParser.parseCookies(cookieStr, new CookieParserCallback(){

            @Override
            public void cookie(String name, String value) {
                list.add(new Cookie(name, value));
            }
        });
        return list;
    }

    public static List<javax.servlet.http.Cookie> parserServletCookie(String cookieStr) {
        final ArrayList<javax.servlet.http.Cookie> list = new ArrayList<javax.servlet.http.Cookie>();
        CookieParser.parseCookies(cookieStr, new CookieParserCallback(){

            @Override
            public void cookie(String name, String value) {
                list.add(new javax.servlet.http.Cookie(name, value));
            }
        });
        return list;
    }

    public static interface CookieParserCallback {
        public void cookie(String var1, String var2);
    }
}

