/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.hpack;

import com.firefly.codec.http2.hpack.AuthorityHttpField;
import com.firefly.codec.http2.hpack.HpackContext;
import com.firefly.codec.http2.hpack.Huffman;
import com.firefly.codec.http2.hpack.MetaDataBuilder;
import com.firefly.codec.http2.hpack.NBitInteger;
import com.firefly.codec.http2.model.BadMessageException;
import com.firefly.codec.http2.model.HttpField;
import com.firefly.codec.http2.model.HttpHeader;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.utils.lang.TypeUtils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpackDecoder {
    public static final Logger log = LoggerFactory.getLogger((String)"firefly-system");
    public static final HttpField.LongValueHttpField CONTENT_LENGTH_0 = new HttpField.LongValueHttpField(HttpHeader.CONTENT_LENGTH, 0L);
    private final HpackContext _context;
    private final MetaDataBuilder _builder;
    private int _localMaxDynamicTableSize;

    public HpackDecoder(int localMaxDynamicTableSize, int maxHeaderSize) {
        this._context = new HpackContext(localMaxDynamicTableSize);
        this._localMaxDynamicTableSize = localMaxDynamicTableSize;
        this._builder = new MetaDataBuilder(maxHeaderSize);
    }

    public HpackContext getHpackContext() {
        return this._context;
    }

    public void setLocalMaxDynamicTableSize(int localMaxdynamciTableSize) {
        this._localMaxDynamicTableSize = localMaxdynamciTableSize;
    }

    public MetaData decode(ByteBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("CtxTbl[%x] decoding %d octets", this._context.hashCode(), buffer.remaining()));
        }
        if (buffer.remaining() > this._builder.getMaxSize()) {
            throw new BadMessageException(431, "Header frame size " + buffer.remaining() + ">" + this._builder.getMaxSize());
        }
        block10: while (buffer.hasRemaining()) {
            HttpField field;
            HttpHeader header;
            String name;
            int name_index;
            boolean indexed;
            byte b;
            if (log.isDebugEnabled() && buffer.hasArray()) {
                int l = Math.min(buffer.remaining(), 32);
                log.debug("decode {}{}", (Object)TypeUtils.toHexString((byte[])buffer.array(), (int)(buffer.arrayOffset() + buffer.position()), (int)l), (Object)(l < buffer.remaining() ? "..." : ""));
            }
            if ((b = buffer.get()) < 0) {
                int index = NBitInteger.decode(buffer, 7);
                HpackContext.Entry entry = this._context.get(index);
                if (entry == null) {
                    throw new BadMessageException(400, "Unknown index " + index);
                }
                if (entry.isStatic()) {
                    if (log.isDebugEnabled()) {
                        log.debug("decode IdxStatic {}", (Object)entry);
                    }
                    this._builder.emit(entry.getHttpField());
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug("decode Idx {}", (Object)entry);
                }
                this._builder.emit(entry.getHttpField());
                continue;
            }
            byte f = (byte)((b & 0xF0) >> 4);
            switch (f) {
                case 2: 
                case 3: {
                    int size = NBitInteger.decode(buffer, 5);
                    if (log.isDebugEnabled()) {
                        log.debug("decode resize=" + size);
                    }
                    if (size > this._localMaxDynamicTableSize) {
                        throw new IllegalArgumentException();
                    }
                    this._context.resize(size);
                    continue block10;
                }
                case 0: 
                case 1: {
                    indexed = false;
                    name_index = NBitInteger.decode(buffer, 4);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    indexed = true;
                    name_index = NBitInteger.decode(buffer, 6);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            boolean huffmanName = false;
            if (name_index > 0) {
                HpackContext.Entry name_entry = this._context.get(name_index);
                name = name_entry.getHttpField().getName();
                header = name_entry.getHttpField().getHeader();
            } else {
                huffmanName = (buffer.get() & 0x80) == 128;
                int length = NBitInteger.decode(buffer, 7);
                this._builder.checkSize(length, huffmanName);
                name = huffmanName ? Huffman.decode(buffer, length) : HpackDecoder.toASCIIString(buffer, length);
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (c < 'A' || c > 'Z') continue;
                    throw new BadMessageException(400, "Uppercase header name");
                }
                header = (HttpHeader)((Object)HttpHeader.CACHE.get(name));
            }
            boolean huffmanValue = (buffer.get() & 0x80) == 128;
            int length = NBitInteger.decode(buffer, 7);
            this._builder.checkSize(length, huffmanValue);
            String value = huffmanValue ? Huffman.decode(buffer, length) : HpackDecoder.toASCIIString(buffer, length);
            if (header == null) {
                field = new HttpField(null, name, value);
            } else {
                switch (header) {
                    case C_STATUS: {
                        if (indexed) {
                            field = new HttpField.IntValueHttpField(header, name, value);
                            break;
                        }
                        field = new HttpField(header, name, value);
                        break;
                    }
                    case C_AUTHORITY: {
                        field = new AuthorityHttpField(value);
                        break;
                    }
                    case CONTENT_LENGTH: {
                        if ("0".equals(value)) {
                            field = CONTENT_LENGTH_0;
                            break;
                        }
                        field = new HttpField.LongValueHttpField(header, name, value);
                        break;
                    }
                    default: {
                        field = new HttpField(header, name, value);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("decoded '{}' by {}/{}/{}", new Object[]{field, name_index > 0 ? "IdxName" : (huffmanName ? "HuffName" : "LitName"), huffmanValue ? "HuffVal" : "LitVal", indexed ? "Idx" : ""});
            }
            this._builder.emit(field);
            if (!indexed || this._context.add(field) != null) continue;
            throw new BadMessageException(431, "Indexed field value too large");
        }
        return this._builder.build();
    }

    public static String toASCIIString(ByteBuffer buffer, int length) {
        StringBuilder builder = new StringBuilder(length);
        int position = buffer.position();
        int start = buffer.arrayOffset() + position;
        int end = start + length;
        buffer.position(position + length);
        byte[] array = buffer.array();
        for (int i = start; i < end; ++i) {
            builder.append((char)(0x7F & array[i]));
        }
        return builder.toString();
    }

    public String toString() {
        return String.format("HpackDecoder@%x{%s}", this.hashCode(), this._context);
    }
}

