/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.frame;

import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.PriorityFrame;
import com.firefly.codec.http2.model.MetaData;

public class HeadersFrame
extends Frame {
    private final int streamId;
    private final MetaData metaData;
    private final PriorityFrame priority;
    private final boolean endStream;

    public HeadersFrame(MetaData metaData, PriorityFrame priority, boolean endStream) {
        this(0, metaData, priority, endStream);
    }

    public HeadersFrame(int streamId, MetaData metaData, PriorityFrame priority, boolean endStream) {
        super(FrameType.HEADERS);
        this.streamId = streamId;
        this.metaData = metaData;
        this.priority = priority;
        this.endStream = endStream;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public PriorityFrame getPriority() {
        return this.priority;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    @Override
    public String toString() {
        return String.format("%s#%d{end=%b}", super.toString(), this.streamId, this.endStream);
    }
}

