/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class WindowUpdateGenerator
extends FrameGenerator {
    public WindowUpdateGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        WindowUpdateFrame windowUpdateFrame = (WindowUpdateFrame)frame;
        return Arrays.asList(this.generateWindowUpdate(windowUpdateFrame.getStreamId(), windowUpdateFrame.getWindowDelta()));
    }

    public ByteBuffer generateWindowUpdate(int streamId, int windowUpdate) {
        if (windowUpdate < 0) {
            throw new IllegalArgumentException("Invalid window update: " + windowUpdate);
        }
        ByteBuffer header = this.generateHeader(FrameType.WINDOW_UPDATE, 4, 0, streamId);
        header.putInt(windowUpdate);
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        return header;
    }
}

