/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SettingsGenerator
extends FrameGenerator {
    public SettingsGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        SettingsFrame settingsFrame = (SettingsFrame)frame;
        return Arrays.asList(this.generateSettings(settingsFrame.getSettings(), settingsFrame.isReply()));
    }

    public ByteBuffer generateSettings(Map<Integer, Integer> settings, boolean reply) {
        int entryLength = 6;
        int length = entryLength * settings.size();
        if (length > this.getMaxFrameSize()) {
            throw new IllegalArgumentException("Invalid settings, too big");
        }
        ByteBuffer header = this.generateHeader(FrameType.SETTINGS, length, reply ? 1 : 0, 0);
        for (Map.Entry<Integer, Integer> entry : settings.entrySet()) {
            header.putShort(entry.getKey().shortValue());
            header.putInt(entry.getValue());
        }
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        return header;
    }
}

