/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.ResetFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class ResetGenerator
extends FrameGenerator {
    public ResetGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        ResetFrame resetFrame = (ResetFrame)frame;
        return Arrays.asList(this.generateReset(resetFrame.getStreamId(), resetFrame.getError()));
    }

    public ByteBuffer generateReset(int streamId, int error) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        ByteBuffer header = this.generateHeader(FrameType.RST_STREAM, 4, 0, streamId);
        header.putInt(error);
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        return header;
    }
}

