/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.PushPromiseFrame;
import com.firefly.codec.http2.hpack.HpackEncoder;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class PushPromiseGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;

    public PushPromiseGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        super(headerGenerator);
        this.encoder = encoder;
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        PushPromiseFrame pushPromiseFrame = (PushPromiseFrame)frame;
        return this.generatePushPromise(pushPromiseFrame.getStreamId(), pushPromiseFrame.getPromisedStreamId(), pushPromiseFrame.getMetaData());
    }

    public List<ByteBuffer> generatePushPromise(int streamId, int promisedStreamId, MetaData metaData) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        if (promisedStreamId < 0) {
            throw new IllegalArgumentException("Invalid promised stream id: " + promisedStreamId);
        }
        LinkedList<ByteBuffer> list = new LinkedList<ByteBuffer>();
        int maxFrameSize = this.getMaxFrameSize();
        int extraSpace = 4;
        ByteBuffer hpacked = ByteBuffer.allocate(maxFrameSize -= extraSpace);
        BufferUtils.clearToFill((ByteBuffer)hpacked);
        this.encoder.encode(hpacked, metaData);
        int hpackedLength = hpacked.position();
        BufferUtils.flipToFlush((ByteBuffer)hpacked, (int)0);
        int length = hpackedLength + extraSpace;
        int flags = 4;
        ByteBuffer header = this.generateHeader(FrameType.PUSH_PROMISE, length, flags, streamId);
        header.putInt(promisedStreamId);
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        list.add(header);
        list.add(hpacked);
        return list;
    }
}

