/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.PriorityFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class PriorityGenerator
extends FrameGenerator {
    public PriorityGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        PriorityFrame priorityFrame = (PriorityFrame)frame;
        return Arrays.asList(this.generatePriority(priorityFrame.getStreamId(), priorityFrame.getParentStreamId(), priorityFrame.getWeight(), priorityFrame.isExclusive()));
    }

    public ByteBuffer generatePriority(int streamId, int parentStreamId, int weight, boolean exclusive) {
        ByteBuffer header = this.generateHeader(FrameType.PRIORITY, 5, 0, streamId);
        this.generatePriorityBody(header, streamId, parentStreamId, weight, exclusive);
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        return header;
    }

    public void generatePriorityBody(ByteBuffer header, int streamId, int parentStreamId, int weight, boolean exclusive) {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        if (parentStreamId < 0) {
            throw new IllegalArgumentException("Invalid parent stream id: " + parentStreamId);
        }
        if (parentStreamId == streamId) {
            throw new IllegalArgumentException("Stream " + streamId + " cannot depend on stream " + parentStreamId);
        }
        if (weight < 1 || weight > 256) {
            throw new IllegalArgumentException("Invalid weight: " + weight);
        }
        if (exclusive) {
            parentStreamId |= Integer.MIN_VALUE;
        }
        header.putInt(parentStreamId);
        header.put((byte)(weight - 1));
    }
}

