/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.PingFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class PingGenerator
extends FrameGenerator {
    public PingGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        PingFrame pingFrame = (PingFrame)frame;
        return Arrays.asList(this.generatePing(pingFrame.getPayload(), pingFrame.isReply()));
    }

    public ByteBuffer generatePing(byte[] payload, boolean reply) {
        if (payload.length != 8) {
            throw new IllegalArgumentException("Invalid payload length: " + payload.length);
        }
        ByteBuffer header = this.generateHeader(FrameType.PING, 8, reply ? 1 : 0, 0);
        header.put(payload);
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        return header;
    }
}

