/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.encode.PriorityGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PriorityFrame;
import com.firefly.codec.http2.hpack.HpackEncoder;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class HeadersGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;
    private final int maxHeaderBlockFragment;
    private final PriorityGenerator priorityGenerator;

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        this(headerGenerator, encoder, 0);
    }

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder, int maxHeaderBlockFragment) {
        super(headerGenerator);
        this.encoder = encoder;
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
        this.priorityGenerator = new PriorityGenerator(headerGenerator);
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeaders(headersFrame.getStreamId(), headersFrame.getMetaData(), headersFrame.getPriority(), headersFrame.isEndStream());
    }

    public List<ByteBuffer> generateHeaders(int streamId, MetaData metaData, PriorityFrame priority, boolean endStream) {
        LinkedList<ByteBuffer> list = new LinkedList<ByteBuffer>();
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int flags = 0;
        if (priority != null) {
            flags = 32;
        }
        int maxFrameSize = this.getMaxFrameSize();
        ByteBuffer hpacked = ByteBuffer.allocate(maxFrameSize);
        BufferUtils.clearToFill((ByteBuffer)hpacked);
        this.encoder.encode(hpacked, metaData);
        int hpackedLength = hpacked.position();
        BufferUtils.flipToFlush((ByteBuffer)hpacked, (int)0);
        if (this.maxHeaderBlockFragment > 0 && hpackedLength > this.maxHeaderBlockFragment) {
            if (endStream) {
                flags |= 1;
            }
            int length = this.maxHeaderBlockFragment;
            if (priority != null) {
                length += 5;
            }
            ByteBuffer header = this.generateHeader(FrameType.HEADERS, length, flags, streamId);
            this.generatePriority(header, priority);
            BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
            list.add(header);
            hpacked.limit(this.maxHeaderBlockFragment);
            list.add(hpacked.slice());
            int position = this.maxHeaderBlockFragment;
            for (int limit = position + this.maxHeaderBlockFragment; limit < hpackedLength; limit += this.maxHeaderBlockFragment) {
                hpacked.position(position).limit(limit);
                header = this.generateHeader(FrameType.CONTINUATION, this.maxHeaderBlockFragment, 0, streamId);
                BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
                list.add(header);
                list.add(hpacked.slice());
                position += this.maxHeaderBlockFragment;
            }
            hpacked.position(position).limit(hpackedLength);
            header = this.generateHeader(FrameType.CONTINUATION, hpacked.remaining(), 4, streamId);
            BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
            list.add(header);
            list.add(hpacked);
        } else {
            flags |= 4;
            if (endStream) {
                flags |= 1;
            }
            int length = hpackedLength;
            if (priority != null) {
                length += 5;
            }
            ByteBuffer header = this.generateHeader(FrameType.HEADERS, length, flags, streamId);
            this.generatePriority(header, priority);
            BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
            list.add(header);
            list.add(hpacked);
        }
        return list;
    }

    private void generatePriority(ByteBuffer header, PriorityFrame priority) {
        if (priority != null) {
            this.priorityGenerator.generatePriorityBody(header, priority.getStreamId(), priority.getParentStreamId(), priority.getWeight(), priority.isExclusive());
        }
    }
}

