/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.GoAwayFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class GoAwayGenerator
extends FrameGenerator {
    public GoAwayGenerator(HeaderGenerator headerGenerator) {
        super(headerGenerator);
    }

    @Override
    public List<ByteBuffer> generate(Frame frame) {
        GoAwayFrame goAwayFrame = (GoAwayFrame)frame;
        return Arrays.asList(this.generateGoAway(goAwayFrame.getLastStreamId(), goAwayFrame.getError(), goAwayFrame.getPayload()));
    }

    public ByteBuffer generateGoAway(int lastStreamId, int error, byte[] payload) {
        if (lastStreamId < 0) {
            throw new IllegalArgumentException("Invalid last stream id: " + lastStreamId);
        }
        int fixedLength = 8;
        int maxPayloadLength = 16384 - fixedLength;
        if (payload != null && payload.length > maxPayloadLength) {
            payload = Arrays.copyOfRange(payload, 0, maxPayloadLength);
        }
        int length = fixedLength + (payload != null ? payload.length : 0);
        ByteBuffer header = this.generateHeader(FrameType.GO_AWAY, length, 0, 0);
        header.putInt(lastStreamId);
        header.putInt(error);
        if (payload != null) {
            header.put(payload);
        }
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        return header;
    }
}

