/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.DataGenerator;
import com.firefly.codec.http2.encode.DisconnectGenerator;
import com.firefly.codec.http2.encode.FrameGenerator;
import com.firefly.codec.http2.encode.GoAwayGenerator;
import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.encode.HeadersGenerator;
import com.firefly.codec.http2.encode.PingGenerator;
import com.firefly.codec.http2.encode.PrefaceGenerator;
import com.firefly.codec.http2.encode.PriorityGenerator;
import com.firefly.codec.http2.encode.PushPromiseGenerator;
import com.firefly.codec.http2.encode.ResetGenerator;
import com.firefly.codec.http2.encode.SettingsGenerator;
import com.firefly.codec.http2.encode.WindowUpdateGenerator;
import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.Frame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.hpack.HpackEncoder;
import com.firefly.utils.lang.Pair;
import java.nio.ByteBuffer;
import java.util.List;

public class Generator {
    private final HeaderGenerator headerGenerator = new HeaderGenerator();
    private final HpackEncoder hpackEncoder;
    private final FrameGenerator[] generators;
    private final DataGenerator dataGenerator;

    public Generator() {
        this(4096, 0);
    }

    public Generator(int maxDynamicTableSize, int maxHeaderBlockFragment) {
        this.hpackEncoder = new HpackEncoder(maxDynamicTableSize);
        this.generators = new FrameGenerator[FrameType.values().length];
        this.generators[FrameType.HEADERS.getType()] = new HeadersGenerator(this.headerGenerator, this.hpackEncoder, maxHeaderBlockFragment);
        this.generators[FrameType.PRIORITY.getType()] = new PriorityGenerator(this.headerGenerator);
        this.generators[FrameType.RST_STREAM.getType()] = new ResetGenerator(this.headerGenerator);
        this.generators[FrameType.SETTINGS.getType()] = new SettingsGenerator(this.headerGenerator);
        this.generators[FrameType.PUSH_PROMISE.getType()] = new PushPromiseGenerator(this.headerGenerator, this.hpackEncoder);
        this.generators[FrameType.PING.getType()] = new PingGenerator(this.headerGenerator);
        this.generators[FrameType.GO_AWAY.getType()] = new GoAwayGenerator(this.headerGenerator);
        this.generators[FrameType.WINDOW_UPDATE.getType()] = new WindowUpdateGenerator(this.headerGenerator);
        this.generators[FrameType.CONTINUATION.getType()] = null;
        this.generators[FrameType.PREFACE.getType()] = new PrefaceGenerator();
        this.generators[FrameType.DISCONNECT.getType()] = new DisconnectGenerator();
        this.dataGenerator = new DataGenerator(this.headerGenerator);
    }

    public void setHeaderTableSize(int headerTableSize) {
        this.hpackEncoder.setRemoteMaxDynamicTableSize(headerTableSize);
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.headerGenerator.setMaxFrameSize(maxFrameSize);
    }

    public <T extends FrameGenerator> T getControlGenerator(FrameType type) {
        return (T)this.generators[type.getType()];
    }

    public List<ByteBuffer> control(Frame frame) {
        return this.generators[frame.getType().getType()].generate(frame);
    }

    public Pair<Integer, List<ByteBuffer>> data(DataFrame frame, int maxLength) {
        return this.dataGenerator.generate(frame, maxLength);
    }

    public void setMaxHeaderListSize(int value) {
        this.hpackEncoder.setMaxHeaderListSize(value);
    }
}

