/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.encode;

import com.firefly.codec.http2.encode.HeaderGenerator;
import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.utils.io.BufferUtils;
import com.firefly.utils.lang.Pair;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class DataGenerator {
    private final HeaderGenerator headerGenerator;

    public DataGenerator(HeaderGenerator headerGenerator) {
        this.headerGenerator = headerGenerator;
    }

    public Pair<Integer, List<ByteBuffer>> generate(DataFrame frame, int maxLength) {
        return this.generateData(frame.getStreamId(), frame.getData(), frame.isEndStream(), maxLength);
    }

    public Pair<Integer, List<ByteBuffer>> generateData(int streamId, ByteBuffer data, boolean last, int maxLength) {
        int maxFrameSize;
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        LinkedList<ByteBuffer> list = new LinkedList<ByteBuffer>();
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int dataLength = data.remaining();
        int length = Math.min(dataLength, Math.min(maxFrameSize = this.headerGenerator.getMaxFrameSize(), maxLength));
        if (length == dataLength) {
            this.generateFrame(streamId, data, last, list);
        } else {
            int limit = data.limit();
            int newLimit = data.position() + length;
            data.limit(newLimit);
            ByteBuffer slice = data.slice();
            data.position(newLimit);
            data.limit(limit);
            this.generateFrame(streamId, slice, false, list);
        }
        return new Pair((Object)length, list);
    }

    private void generateFrame(int streamId, ByteBuffer data, boolean last, List<ByteBuffer> list) {
        int length = data.remaining();
        int flags = 0;
        if (last) {
            flags |= 1;
        }
        ByteBuffer header = this.headerGenerator.generate(FrameType.DATA, 9 + length, length, flags, streamId);
        BufferUtils.flipToFlush((ByteBuffer)header, (int)0);
        list.add(header);
        if (data.remaining() > 0) {
            list.add(data);
        }
    }
}

