/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.decode;

import com.firefly.codec.http2.decode.Parser;
import com.firefly.codec.http2.decode.PrefaceParser;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerParser
extends Parser {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final Listener listener;
    private final PrefaceParser prefaceParser;
    private State state = State.PREFACE;
    private boolean notifyPreface = true;

    public ServerParser(Listener listener, int maxDynamicTableSize, int maxHeaderSize) {
        super(listener, maxDynamicTableSize, maxHeaderSize);
        this.listener = listener;
        this.prefaceParser = new PrefaceParser(listener);
    }

    public void directUpgrade() {
        if (this.state != State.PREFACE) {
            throw new IllegalStateException();
        }
        this.prefaceParser.directUpgrade();
    }

    public void standardUpgrade() {
        if (this.state != State.PREFACE) {
            throw new IllegalStateException();
        }
        this.notifyPreface = false;
    }

    @Override
    public void parse(ByteBuffer buffer) {
        try {
            block7: while (true) {
                switch (this.state) {
                    case PREFACE: {
                        if (!this.prefaceParser.parse(buffer)) {
                            return;
                        }
                        if (this.notifyPreface) {
                            this.onPreface();
                        }
                        this.state = State.SETTINGS;
                        continue block7;
                    }
                    case SETTINGS: {
                        if (!this.parseHeader(buffer)) {
                            return;
                        }
                        if (this.getFrameType() != FrameType.SETTINGS.getType() || this.hasFlag(1)) {
                            BufferUtils.clear((ByteBuffer)buffer);
                            this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "invalid_preface");
                            return;
                        }
                        if (!this.parseBody(buffer)) {
                            return;
                        }
                        this.state = State.FRAMES;
                        continue block7;
                    }
                    case FRAMES: {
                        super.parse(buffer);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            log.error("server parser error", x);
            BufferUtils.clear((ByteBuffer)buffer);
            this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "parser_error");
            return;
        }
    }

    protected void onPreface() {
        this.notifyPreface();
    }

    private void notifyPreface() {
        try {
            this.listener.onPreface();
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    private static enum State {
        PREFACE,
        SETTINGS,
        FRAMES;

    }

    public static interface Listener
    extends Parser.Listener {
        public void onPreface();

        public static class Adapter
        extends Parser.Listener.Adapter
        implements Listener {
            @Override
            public void onPreface() {
            }
        }
    }
}

