/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.decode;

import com.firefly.codec.http2.decode.Parser;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.PrefaceFrame;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefaceParser {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final Parser.Listener listener;
    private int cursor;

    public PrefaceParser(Parser.Listener listener) {
        this.listener = listener;
    }

    protected void directUpgrade() {
        if (this.cursor != 0) {
            throw new IllegalStateException();
        }
        this.cursor = PrefaceFrame.PREFACE_PREAMBLE_BYTES.length;
    }

    public boolean parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            byte currByte = buffer.get();
            if (currByte != PrefaceFrame.PREFACE_BYTES[this.cursor]) {
                BufferUtils.clear((ByteBuffer)buffer);
                this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "invalid_preface");
                return false;
            }
            ++this.cursor;
            if (this.cursor != PrefaceFrame.PREFACE_BYTES.length) continue;
            this.cursor = 0;
            if (log.isDebugEnabled()) {
                log.debug("Parsed preface bytes");
            }
            return true;
        }
        return false;
    }

    protected void notifyConnectionFailure(int error, String reason) {
        try {
            this.listener.onConnectionFailure(error, reason);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }
}

