/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.decode;

import com.firefly.codec.http2.decode.BodyParser;
import com.firefly.codec.http2.decode.HeaderParser;
import com.firefly.codec.http2.decode.Parser;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.PingFrame;
import java.nio.ByteBuffer;

public class PingBodyParser
extends BodyParser {
    private State state = State.PREPARE;
    private int cursor;
    private byte[] payload;

    public PingBodyParser(HeaderParser headerParser, Parser.Listener listener) {
        super(headerParser, listener);
    }

    private void reset() {
        this.state = State.PREPARE;
        this.cursor = 0;
        this.payload = null;
    }

    @Override
    public boolean parse(ByteBuffer buffer) {
        block5: while (buffer.hasRemaining()) {
            switch (this.state) {
                case PREPARE: {
                    if (this.getStreamId() != 0) {
                        return this.connectionFailure(buffer, ErrorCode.PROTOCOL_ERROR.code, "invalid_ping_frame");
                    }
                    if (this.getBodyLength() != 8) {
                        return this.connectionFailure(buffer, ErrorCode.FRAME_SIZE_ERROR.code, "invalid_ping_frame");
                    }
                    this.state = State.PAYLOAD;
                    continue block5;
                }
                case PAYLOAD: {
                    this.payload = new byte[8];
                    if (buffer.remaining() >= 8) {
                        buffer.get(this.payload);
                        return this.onPing(this.payload);
                    }
                    this.state = State.PAYLOAD_BYTES;
                    this.cursor = 8;
                    continue block5;
                }
                case PAYLOAD_BYTES: {
                    this.payload[8 - this.cursor] = buffer.get();
                    --this.cursor;
                    if (this.cursor != 0) continue block5;
                    return this.onPing(this.payload);
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private boolean onPing(byte[] payload) {
        PingFrame frame = new PingFrame(payload, this.hasFlag(1));
        this.reset();
        this.notifyPing(frame);
        return true;
    }

    private static enum State {
        PREPARE,
        PAYLOAD,
        PAYLOAD_BYTES;

    }
}

