/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.decode;

import com.firefly.codec.http2.decode.BodyParser;
import com.firefly.codec.http2.decode.ContinuationBodyParser;
import com.firefly.codec.http2.decode.DataBodyParser;
import com.firefly.codec.http2.decode.GoAwayBodyParser;
import com.firefly.codec.http2.decode.HeaderBlockFragments;
import com.firefly.codec.http2.decode.HeaderBlockParser;
import com.firefly.codec.http2.decode.HeaderParser;
import com.firefly.codec.http2.decode.HeadersBodyParser;
import com.firefly.codec.http2.decode.PingBodyParser;
import com.firefly.codec.http2.decode.PriorityBodyParser;
import com.firefly.codec.http2.decode.PushPromiseBodyParser;
import com.firefly.codec.http2.decode.ResetBodyParser;
import com.firefly.codec.http2.decode.SettingsBodyParser;
import com.firefly.codec.http2.decode.WindowUpdateBodyParser;
import com.firefly.codec.http2.frame.DataFrame;
import com.firefly.codec.http2.frame.ErrorCode;
import com.firefly.codec.http2.frame.FrameType;
import com.firefly.codec.http2.frame.GoAwayFrame;
import com.firefly.codec.http2.frame.HeadersFrame;
import com.firefly.codec.http2.frame.PingFrame;
import com.firefly.codec.http2.frame.PriorityFrame;
import com.firefly.codec.http2.frame.PushPromiseFrame;
import com.firefly.codec.http2.frame.ResetFrame;
import com.firefly.codec.http2.frame.SettingsFrame;
import com.firefly.codec.http2.frame.WindowUpdateFrame;
import com.firefly.codec.http2.hpack.HpackDecoder;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static Logger log = LoggerFactory.getLogger((String)"firefly-system");
    private final Listener listener;
    private final HeaderParser headerParser;
    private final BodyParser[] bodyParsers;
    private boolean continuation;
    private State state = State.HEADER;

    public Parser(Listener listener, int maxDynamicTableSize, int maxHeaderSize) {
        this.listener = listener;
        this.headerParser = new HeaderParser();
        this.bodyParsers = new BodyParser[FrameType.values().length];
        HeaderBlockParser headerBlockParser = new HeaderBlockParser(new HpackDecoder(maxDynamicTableSize, maxHeaderSize));
        HeaderBlockFragments headerBlockFragments = new HeaderBlockFragments();
        this.bodyParsers[FrameType.DATA.getType()] = new DataBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.HEADERS.getType()] = new HeadersBodyParser(this.headerParser, listener, headerBlockParser, headerBlockFragments);
        this.bodyParsers[FrameType.PRIORITY.getType()] = new PriorityBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.RST_STREAM.getType()] = new ResetBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.SETTINGS.getType()] = new SettingsBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.PUSH_PROMISE.getType()] = new PushPromiseBodyParser(this.headerParser, listener, headerBlockParser);
        this.bodyParsers[FrameType.PING.getType()] = new PingBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.GO_AWAY.getType()] = new GoAwayBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.WINDOW_UPDATE.getType()] = new WindowUpdateBodyParser(this.headerParser, listener);
        this.bodyParsers[FrameType.CONTINUATION.getType()] = new ContinuationBodyParser(this.headerParser, listener, headerBlockParser, headerBlockFragments);
    }

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(ByteBuffer buffer) {
        try {
            block6: while (true) {
                switch (this.state) {
                    case HEADER: {
                        if (this.parseHeader(buffer)) continue block6;
                        return;
                    }
                    case BODY: {
                        if (!this.parseBody(buffer)) return;
                        continue block6;
                    }
                }
                break;
            }
            throw new IllegalStateException();
        }
        catch (Throwable x) {
            log.error("HTTP2 parsing error", x);
            BufferUtils.clear((ByteBuffer)buffer);
            this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "parser_error");
            return;
        }
    }

    protected boolean parseHeader(ByteBuffer buffer) {
        if (!this.headerParser.parse(buffer)) {
            return false;
        }
        int frameType = this.getFrameType();
        if (log.isDebugEnabled()) {
            log.debug("Parsed {} frame header", (Object)FrameType.from(frameType));
        }
        if (this.continuation) {
            if (frameType != FrameType.CONTINUATION.getType()) {
                BufferUtils.clear((ByteBuffer)buffer);
                this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "continuation_frame_expected");
                return false;
            }
            if (this.headerParser.hasFlag(4)) {
                this.continuation = false;
            }
        } else if (frameType == FrameType.HEADERS.getType() && !this.headerParser.hasFlag(4)) {
            this.continuation = true;
        }
        this.state = State.BODY;
        return true;
    }

    protected boolean parseBody(ByteBuffer buffer) {
        int type = this.getFrameType();
        if (type < 0 || type >= this.bodyParsers.length) {
            BufferUtils.clear((ByteBuffer)buffer);
            this.notifyConnectionFailure(ErrorCode.PROTOCOL_ERROR.code, "unknown_frame_type_" + type);
            return false;
        }
        FrameType frameType = FrameType.from(type);
        if (log.isDebugEnabled()) {
            log.debug("Parsing {} frame", (Object)frameType);
        }
        BodyParser bodyParser = this.bodyParsers[type];
        if (this.headerParser.getLength() == 0) {
            bodyParser.emptyBody(buffer);
        } else if (!bodyParser.parse(buffer)) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Parsed {} frame", (Object)frameType);
        }
        this.reset();
        return true;
    }

    protected int getFrameType() {
        return this.headerParser.getFrameType();
    }

    protected boolean hasFlag(int bit) {
        return this.headerParser.hasFlag(bit);
    }

    protected void notifyConnectionFailure(int error, String reason) {
        try {
            this.listener.onConnectionFailure(error, reason);
        }
        catch (Throwable x) {
            log.error("Failure while notifying listener {}", (Object)x, (Object)this.listener);
        }
    }

    private static enum State {
        HEADER,
        BODY;

    }

    public static interface Listener {
        public void onData(DataFrame var1);

        public void onHeaders(HeadersFrame var1);

        public void onPriority(PriorityFrame var1);

        public void onReset(ResetFrame var1);

        public void onSettings(SettingsFrame var1);

        public void onPushPromise(PushPromiseFrame var1);

        public void onPing(PingFrame var1);

        public void onGoAway(GoAwayFrame var1);

        public void onWindowUpdate(WindowUpdateFrame var1);

        public void onConnectionFailure(int var1, String var2);

        public static class Adapter
        implements Listener {
            @Override
            public void onData(DataFrame frame) {
            }

            @Override
            public void onHeaders(HeadersFrame frame) {
            }

            @Override
            public void onPriority(PriorityFrame frame) {
            }

            @Override
            public void onReset(ResetFrame frame) {
            }

            @Override
            public void onSettings(SettingsFrame frame) {
            }

            @Override
            public void onPushPromise(PushPromiseFrame frame) {
            }

            @Override
            public void onPing(PingFrame frame) {
            }

            @Override
            public void onGoAway(GoAwayFrame frame) {
            }

            @Override
            public void onWindowUpdate(WindowUpdateFrame frame) {
            }

            @Override
            public void onConnectionFailure(int error, String reason) {
                log.warn("Connection failure: {}/{}", (Object)error, (Object)reason);
            }
        }
    }
}

