/*
 * Decompiled with CFR 0.152.
 */
package com.firefly.codec.http2.decode;

import com.firefly.codec.http2.hpack.HpackDecoder;
import com.firefly.codec.http2.model.MetaData;
import com.firefly.utils.io.BufferUtils;
import java.nio.ByteBuffer;

public class HeaderBlockParser {
    private final HpackDecoder hpackDecoder;
    private ByteBuffer blockBuffer;

    public HeaderBlockParser(HpackDecoder hpackDecoder) {
        this.hpackDecoder = hpackDecoder;
    }

    public MetaData parse(ByteBuffer buffer, int blockLength) {
        ByteBuffer toDecode;
        int accumulated = this.blockBuffer == null ? 0 : this.blockBuffer.position();
        int remaining = blockLength - accumulated;
        if (buffer.remaining() < remaining) {
            if (this.blockBuffer == null) {
                this.blockBuffer = ByteBuffer.allocate(blockLength);
                BufferUtils.clearToFill((ByteBuffer)this.blockBuffer);
            }
            this.blockBuffer.put(buffer);
            return null;
        }
        int limit = buffer.limit();
        buffer.limit(buffer.position() + remaining);
        if (this.blockBuffer != null) {
            this.blockBuffer.put(buffer);
            BufferUtils.flipToFlush((ByteBuffer)this.blockBuffer, (int)0);
            toDecode = this.blockBuffer;
        } else {
            toDecode = buffer;
        }
        MetaData result = this.hpackDecoder.decode(toDecode);
        buffer.limit(limit);
        if (this.blockBuffer != null) {
            this.blockBuffer = null;
        }
        return result;
    }
}

